package com.xforceplus.seller.invoice.client.model;

import java.util.stream.Stream;

/**
 * 红字信息 与 预制发票 比对结果
 */
public enum RedLetterComparedEnum {

    /**
     * 红字信息和预制发票完全一致，可开票
     */
    CONSISTENT_CAN_ISSUE("1", "一致可开票"),

    NOT_CONSISTENT_CAN_ISSUE("2", "不一致可开票"),

    NOT_CONSISTENT_NOT_ISSUE("3", "不一致不可开票"),

    PENDING_CONSISTENT_CAN_ISSUE("4", "一致待确定可开票");


    private final String code;

    private final String description;

    RedLetterComparedEnum(String code, String desc)
    {
        this.code = code;
        this.description = desc;
    }

    public String value()
    {
        return  this.code;
    }

    public String description(){return this.description;}

    public static String getRedLetterComparedDescBy(String value) {
        return Stream.of(RedLetterComparedEnum.values())
                .filter(r -> r.value().equals(value))
                .map(RedLetterComparedEnum::description)
                .findFirst().orElse(null);
    }

    public static RedLetterComparedEnum from(String value){
       return Stream.of(RedLetterComparedEnum.values())
               .filter(r -> r.value().equals(value))
               .findFirst().orElse(null);
    }
}
