package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.client.model.vo.BankControlVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 数据
 */
@ApiModel(description = "数据")
@JsonInclude(NON_NULL)
@ToString
@Data
public class ResponseData {

    @JsonProperty("preInvoiceIds")
    private List<Long> preInvoiceIds = new ArrayList<Long>();

    @JsonProperty("leftPreInvoiceIds")
    private List<Long> leftPreInvoiceIds = new ArrayList<Long>();

    @JsonProperty("companyName")
    private String companyName = null;

    @ApiModelProperty("最新公司名称")
    private String newCompanyName;

    @JsonProperty("companyId")
    private Long companyId = null;

    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;

    @JsonProperty("invoiceCount")
    private Integer invoiceCount = null;

    @JsonProperty("amountWithTax")
    private String amountWithTax = null;

    @JsonProperty("amountWithoutTax")
    private String amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private String taxAmount = null;

    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    @JsonProperty("terminalList")
    private List<TerminalInfo> terminalList = new ArrayList<TerminalInfo>();

    @ApiModelProperty(value = "打印终端列表")
    @JsonProperty("printerTerminalList")
    private List<PrintTerminalInfo> printerTerminalList;

    @ApiModelProperty(value = "蓝字发票号码")
    private String invoiceNo;

    @ApiModelProperty(value = "蓝字发票代码")
    private String invoiceCode;

    @ApiModelProperty(value = "是否跳转发票详情")
    private boolean forwardFlag;

    @ApiModelProperty(value = "单点登陆路径")
    private String ssoUrl;

    @ApiModelProperty(value = "蓝字发票状态")
    private Integer status;

    @ApiModelProperty(value = "红字信息比对信息")
    private RedNoCompareInfo redNoCompareInfo;

    @ApiModelProperty(value = "是否替换电话号码格式")
    private String updateTelNoMessage;

    @ApiModelProperty("银行信息")
    private List<BankControlVo> list;

}
