package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票开票信息
 */
@ApiModel(description = "预制发票开票信息")

@JsonInclude(NON_NULL)
public class SellerOperationInfo {
    @JsonProperty("taskId")
    @NotNull
    private Long taskId;

    @JsonProperty("batchNoList")
    @NotEmpty
    private List<Long> batchNoList;

    /**
     * 任务Id
     * @return taskId
     **/
    @ApiModelProperty(value = "任务Id")
    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    /**
     * 批次号Id集合
     * @return batchNoList
     **/
    @ApiModelProperty(value = "批次号Id集合")
    public List<Long> getBatchNoList() {
        return batchNoList;
    }

    public void setBatchNoList(List<Long> batchNoList) {
        this.batchNoList = batchNoList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SellerOperationInfo sellerOperationInfo = (SellerOperationInfo) o;
        return Objects.equals(this.taskId, sellerOperationInfo.taskId) &&
                Objects.equals(this.batchNoList, sellerOperationInfo.batchNoList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(taskId, batchNoList);
    }


    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Override
    public String toString() {
        return "SellerOperationInfo{" +
                "taskId=" + taskId +
                ", batchNoList=" + batchNoList +
                '}';
    }
}
