package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel("申请红字信息发票信息")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ApplyRedLetterHead {
    @ApiModelProperty("申请流水号")
    @NotNull(message = "applySerialNo参数为必填项")
    private String applySerialNo;
    @ApiModelProperty("")
    private Integer oilMemo;
    @ApiModelProperty("特殊票种类型")
    private String specialType;
    @ApiModelProperty("特殊票种类型申请原因")
    private String specialTypeApplyReason;
    @ApiModelProperty("购方税号")
    @NotNull(message = "buyerTaxNo参数为必填项")
    private String buyerTaxNo;
    @ApiModelProperty("购方名称")
    @NotNull(message = "buyerName参数为必填项")
    private String buyerName;
    @ApiModelProperty("销方税号")
    @NotNull(message = "sellerTaxNo参数为必填项")
    private String sellerTaxNo;
    @ApiModelProperty("销方名称")
    @NotNull(message = "sellerName参数为必填项")
    private String sellerName;
    @ApiModelProperty("原发票代码")
    @NotNull(message = "originInvoiceCode参数为必填项")
    private String originInvoiceCode;
    @ApiModelProperty("原发票号码")
    @NotNull(message = "originInvoiceNo参数为必填项")
    private String originInvoiceNo;
    @ApiModelProperty("原发票类型")
    @NotNull(message = "originInvoiceType参数为必填项")
    private String originInvoiceType;
    @ApiModelProperty("原开票日期")
    @NotNull(message = "originDateIssued参数为必填项")
    private String originDateIssued;
    @ApiModelProperty("")
    private Integer applicationReason;
    @ApiModelProperty("金额信息")
    @NotNull(message = "amount参数为必填项")
    @Valid
    private InvoiceAmount amount;
    @ApiModelProperty("红字明细信息")
    @Valid
    private List<RedLetterDetail<ApplyRedLetterDetailAmount>> details;
}
