package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("撤销红字信息请求")
public class CancelApplyRedLetterRequest {
    @ApiModelProperty("操作终端")
    @NotNull(message = "terminal参数为必填项")
    @Valid
    private OperatingTerminal terminal;
    @ApiModelProperty("红字信息编号")
    private List<String> redLetterNumbers;
}
