package com.xforceplus.seller.invoice.client.model.pdf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;


@ApiModel(
        description = "金额信息"
)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AutoPdfInvoiceDetailAmountInfo {

    @JsonProperty("amountWithoutTax")
    private String amountWithoutTax = null;
    @JsonProperty("taxAmount")
    private String taxAmount = null;
    @JsonProperty("quantity")
    private String quantity = null;
    @JsonProperty("unitPrice")
    private String unitPrice = null;

    public AutoPdfInvoiceDetailAmountInfo() {
    }

    public AutoPdfInvoiceDetailAmountInfo(String amountWithoutTax, String taxAmount, String quantity, String unitPrice) {
        this.amountWithoutTax = amountWithoutTax;
        this.taxAmount = taxAmount;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
    }

    @JsonIgnore
    public AutoPdfInvoiceDetailAmountInfo unitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @ApiModelProperty("单价")
    public String getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    @JsonIgnore
    public AutoPdfInvoiceDetailAmountInfo quantity(String quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty("数量")
    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    @JsonIgnore
    public AutoPdfInvoiceDetailAmountInfo amountWithoutTax(String amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    @ApiModelProperty("不含税金额")
    public String getAmountWithoutTax() {
        return this.amountWithoutTax;
    }

    public void setAmountWithoutTax(String amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public AutoPdfInvoiceDetailAmountInfo taxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty("税额")
    public String getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AutoPdfInvoiceDetailAmountInfo that = (AutoPdfInvoiceDetailAmountInfo) o;
        return Objects.equals(amountWithoutTax, that.amountWithoutTax) &&
                Objects.equals(taxAmount, that.taxAmount) &&
                Objects.equals(quantity, that.quantity) &&
                Objects.equals(unitPrice, that.unitPrice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amountWithoutTax, taxAmount, quantity, unitPrice);
    }

    @Override
    public String toString() {
        return "AutoPdfInvoiceDetailAmountInfo{" +
                "amountWithoutTax='" + amountWithoutTax + '\'' +
                ", taxAmount='" + taxAmount + '\'' +
                ", quantity='" + quantity + '\'' +
                ", unitPrice='" + unitPrice + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }
}

