package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import java.util.Objects;

public class ControlInfo {

    @JsonProperty("productOil")
    private String productOil = null;
    @JsonProperty("saleList")
    private String saleList = null;

    public ControlInfo(String productOil, String saleList) {
        this.productOil = productOil;
        this.saleList = saleList;
    }

    public ControlInfo() {
    }

    @JsonIgnore
    public ControlInfo productOil(String productOil) {
        this.productOil = productOil;
        return this;
    }

    @Valid
    @ApiModelProperty("成品油标识")
    public String getProductOil() {
        return this.productOil;
    }

    public void setProductOil(String productOil) {
        this.productOil = productOil;
    }

    @JsonIgnore
    public ControlInfo saleList(String saleList) {
        this.saleList = saleList;
        return this;
    }

    @Valid
    @ApiModelProperty("是否有销货清单(返回开具请求中的入参)")
    public String getSaleList() {
        return this.saleList;
    }

    public void setSaleList(String saleList) {
        this.saleList = saleList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ControlInfo that = (ControlInfo) o;
        return Objects.equals(productOil, that.productOil) &&
                Objects.equals(saleList, that.saleList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(productOil, saleList);
    }

    @Override
    public String toString() {
        return "ControlInfo{" +
                "productOil='" + productOil + '\'' +
                ", saleList='" + saleList + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
