package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

@ApiModel(
    description = "税收信息"
)
public class TaxInfo {

    @JsonProperty("preferentialTax")
    private String preferentialTax = null;
    @JsonProperty("taxPolicy")
    private String taxPolicy = null;
    @JsonProperty("taxRate")
    private String taxRate = null;
    @JsonProperty("zeroTax")
    private String zeroTax = null;
    @JsonProperty("goodsNoVer")
    private String goodsNoVer = null;
    @JsonProperty("taxCode")
    private String taxCode = null;
    @JsonProperty("taxCodeVersion")
    private String taxCodeVersion = null;

    public TaxInfo(String preferentialTax, String taxPolicy, String taxRate, String zeroTax,
                   String goodsNoVer, String taxCode, String taxCodeVersion) {
        this.preferentialTax = preferentialTax;
        this.taxPolicy = taxPolicy;
        this.taxRate = taxRate;
        this.zeroTax = zeroTax;
        this.goodsNoVer = goodsNoVer;
        this.taxCode = taxCode;
        this.taxCodeVersion = taxCodeVersion;
    }

    public TaxInfo() {
    }

    @JsonIgnore
    public TaxInfo preferentialTax(String preferentialTax) {
        this.preferentialTax = preferentialTax;
        return this;
    }

    @ApiModelProperty("是否享受税收优惠政策")
    public String getPreferentialTax() {
        return this.preferentialTax;
    }

    public void setPreferentialTax(String preferentialTax) {
        this.preferentialTax = preferentialTax;
    }

    @JsonIgnore
    public TaxInfo taxPolicy(String taxPolicy) {
        this.taxPolicy = taxPolicy;
        return this;
    }

    @ApiModelProperty("享受税收优惠政策内容。0税率时： 根据 zeroTax 的情况，分别填： 免税 / 不征税 / 普通0税率")
    public String getTaxPolicy() {
        return this.taxPolicy;
    }

    public void setTaxPolicy(String taxPolicy) {
        this.taxPolicy = taxPolicy;
    }

    @JsonIgnore
    public TaxInfo taxRate(String taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty("税率(例如，16%传0.16)")
    public String getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    @JsonIgnore
    public TaxInfo zeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
        return this;
    }

    @ApiModelProperty("税率标志 (空-非0税率；0-出口退税 1-免税 2-不征税 3-普通0税率)")
    public String getZeroTax() {
        return this.zeroTax;
    }

    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
    }

    @JsonIgnore
    public TaxInfo goodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer;
        return this;
    }

    @ApiModelProperty("税编版本号（废弃）")
    public String getGoodsNoVer() {
        return this.goodsNoVer;
    }

    public void setGoodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer;
    }

    @JsonIgnore
    public TaxInfo taxCodeVersion(String taxCodeVersion) {
        this.taxCodeVersion = taxCodeVersion;
        return this;
    }

    @ApiModelProperty("税编版本号")
    public String getTaxCodeVersion() {
        return this.taxCodeVersion;
    }

    public void setTaxCodeVersion(String taxCodeVersion) {
        this.taxCodeVersion = taxCodeVersion;
    }

    @JsonIgnore
    public TaxInfo taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @ApiModelProperty("税编代码")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TaxInfo taxInfo = (TaxInfo) o;
        return Objects.equals(preferentialTax, taxInfo.preferentialTax) &&
                Objects.equals(taxPolicy, taxInfo.taxPolicy) &&
                Objects.equals(taxRate, taxInfo.taxRate) &&
                Objects.equals(zeroTax, taxInfo.zeroTax) &&
                Objects.equals(goodsNoVer, taxInfo.goodsNoVer) &&
                Objects.equals(taxCode, taxInfo.taxCode) &&
                Objects.equals(taxCodeVersion, taxInfo.taxCodeVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(preferentialTax, taxPolicy, taxRate, zeroTax, goodsNoVer, taxCode, taxCodeVersion);
    }

    @Override
    public String toString() {
        return "TaxInfo{" +
                "preferentialTax='" + preferentialTax + '\'' +
                ", taxPolicy='" + taxPolicy + '\'' +
                ", taxRate='" + taxRate + '\'' +
                ", zeroTax='" + zeroTax + '\'' +
                ", goodsNoVer='" + goodsNoVer + '\'' +
                ", taxCode='" + taxCode + '\'' +
                ", taxCodeVersion='" + taxCodeVersion + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
