package com.xforceplus.seller.invoice.client;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@ApiModel(description = "统计信息")
@EqualsAndHashCode
@ToString
@Data
public class SellerStatisticsInfo implements Serializable {
  @JsonProperty("id")
  @JSONField(serializeUsing = ToStringSerializer.class)
  private Long id = null;

  @JsonProperty("sellerTenantId")
  @ApiModelProperty("租户ID")
  private Long sellerTenantId = null;

  @JsonProperty("sellerTaxNo")
  @ApiModelProperty("税号")
  private String sellerTaxNo = null;

  @JsonProperty("sellerCompanyName")
  @ApiModelProperty("公司名称")
  private String sellerCompanyName = null;

  @JsonProperty("quarterlyTotal")
  @ApiModelProperty("季度累计")
  private BigDecimal quarterlyTotal = null;

  @ApiModelProperty("季度是否超限")
  private Boolean quarterlyOverLimit = null;

  @JsonProperty("annualTotal")
  @ApiModelProperty("年度累计")
  private BigDecimal annualTotal = null;

  @ApiModelProperty("年度是否超限")
  private Boolean annualOverLimit = null;
}
