package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.QueryPreModel;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;


/**
 * 查询业务单待提交，但是无预制发票的单子
 * 状态不正确的单据
 */
public interface CustomInvoiceApi {

    @ApiOperation(value = "查询业务单待提交,但是无预制发票的业务单", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"AutoInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询业务单待提交,但是无预制发票的业务单", response = Response.class)})
    @RequestMapping(value = "unDone",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<ArrayList<Long>> customQueryPreInvoice(@ApiParam(value = "查询开具完成的预制发票", required = true) @RequestBody QueryPreModel queryPreModel);

    @ApiOperation(value = "查询全作废,全红冲.无已开金额 单据", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"AutoInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询全作废,全红冲.无已开金额 单据", response = Response.class)})
    @RequestMapping(value = "done",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<ArrayList<Long>> customQueryInvoice(@ApiParam(value = "查询全作废,全红冲.无已开金额 单据", required = true) @RequestBody QueryPreModel queryPreModel);

}
