package com.xforceplus.seller.invoice.client.api;

import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.xforceplus.seller.invoice.client.model.MsInvoiceAttachmentQueryRequest;
import com.xforceplus.seller.invoice.client.model.MsUploadAttachment;
import com.xforceplus.xplatframework.model.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;

@Api(value = "invoiceAttachment", description = "the invoiceAttachment API")
public interface InvoiceAttachmentApi {

	@ApiOperation(value = "保存发票附件", notes = "", response = Response.class, authorizations = {
			@Authorization(value = "X-Access-Token"),
			@Authorization(value = "X-Operation-Token") }, tags = { "SellerInvoiceAttachment", })
	@ApiResponses(value = { @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
	@RequestMapping(value = "/attachment/save", produces = { "application/json" }, method = RequestMethod.POST)
	Response saveAttachment(@ApiParam(value = "发票附件上传成功回调参数") @Validated MsUploadAttachment uploadAttachment);
 
	@ApiOperation(value = "查询发票附件", notes = "", response = Response.class, authorizations = {
			@Authorization(value = "X-Access-Token"),
			@Authorization(value = "X-Operation-Token") }, tags = { "SellerInvoiceAttachment", })
	@ApiResponses(value = { @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
	@RequestMapping(value = "/attachment/get", produces = { "application/json" }, method = RequestMethod.POST)
	Response getAttachment(
            @ApiParam(value = "发票批次号", required = true) @Validated MsInvoiceAttachmentQueryRequest invoiceAttachmentQueryRequest);
 
	@ApiOperation(value = "查询发票附件下载信息", notes = "", response = Response.class, authorizations = {
			@Authorization(value = "X-Access-Token"),
			@Authorization(value = "X-Operation-Token") }, tags = { "SellerInvoiceAttachment", })
	@ApiResponses(value = { @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
	@RequestMapping(value = "/attachment/getDownloadInfo", produces = {
			"application/json" }, method = RequestMethod.POST)
	Response getDownloadInfo(@RequestBody MsInvoiceAttachmentQueryRequest invoiceAttachmentQueryRequest);
}
