package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.PreInvoiceErrorRequest;
import com.xforceplus.seller.invoice.client.model.ant.MsGetErrorCollectionResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * 项目名称: 预制发票操作错误日志查询API
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): wangjingshuang
 * 创建日期:      2020年12月15日14:28:33
 */
public interface PreInvoiceErrorApi {

    @ApiOperation(value = "预制发票操作错误描述查询", notes = "", response = MsGetErrorCollectionResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"PreInvoiceError",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "预制发票操作错误描述结果", response = MsGetErrorCollectionResponse.class)})
    @RequestMapping(value = "/pre-invoice/query-preInvoice-error",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsGetErrorCollectionResponse queryPreInvoiceError(@ApiParam(value = "预制发票操作错误描述查询", required = true) @RequestBody PreInvoiceErrorRequest preInvoiceErrorRequest);
}
