package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Api(value = "sellerPreInvoice", description = "the sellerPreInvoice API")
public interface SellerPreInvoiceApi {

    @ApiOperation(value = "根据业务单id作废未开具的发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/abandonUnissuedInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response abandonUnissuedInvoice(@RequestBody AbandonUnissuedRequest abandonUnissuedRequest);

    @ApiOperation(value = "根据业务单id查询拆票结果", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/countPreBillByBillId",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response countPreBillByBillId(@RequestBody BillInfo billInfo);

    @ApiOperation(value = "根据票面抬头信息和业务单id更新预制发票票面抬头", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/updatePreInvoiceByTtitle",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updatePreInvoiceByTtitle(@RequestBody PreInvoiceTtitleRequest preInvoiceTtitleRequest);

    @ApiOperation(value = "根据票面人信息和业务单id更新预制发票票面人", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/updatePreInvoiceByOperator",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updatePreInvoiceByOperator(@RequestBody PreInvoiceOperatorRequest preInvoiceOperatorRequest);

    @ApiOperation(value = "根据公司信息和业务单id更新预制发票公司名称", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/updatePreInvoiceByCompanyName",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updatePreInvoiceByCompanyName(@RequestBody PreInvoiceCompanyNameRequest preInvoiceCompanyNameRequest);

    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/ApplyRedNoByBatch",
            produces = {"application/json"},
            method = RequestMethod.POST)
    public Response applyRedNoByBatch(@RequestParam("batchNo") Long batchNo);


    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/applyRedNoByPreInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    public Response applyRedNoByPreInvoice(@RequestBody List<Long> preInvoiceIds);


    @ApiOperation(value = "检验或者删除红字信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/validOrDelRedNotification",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response validOrDelRedNotification(@RequestBody ValidOrDelRedNotificationRequest validOrDelRedNotificationRequest);

    @ApiOperation(value = "作废或者删除预制发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/abandonOrDelPreInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response abandonOrDelPreInvoice(@RequestBody AbandonOrDelPreInvoiceRequest abandonOrDelPreInvoiceRequest);

    @ApiOperation(value = "作废业务单前检验预制发票状态", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/checkPreInvoiceBeforeDel",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response checkPreInvoiceBeforeDel(@RequestBody AbandonOrDelPreInvoiceRequest abandonOrDelPreInvoiceRequest);

    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/checkPreInvoicesBeforeDelAndNoDeleteResponse",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<CheckPreInvoicesBeforeDelAndNoDelete> checkPreInvoicesBeforeDelAndNoDeleteResponse(@RequestBody AbandonOrDelPreInvoiceRequest abandonOrDelPreInvoiceRequest);

    @ApiOperation(value = "根据批次号删除预制发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/delPreInvoiceByBatchNos",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response delPreInvoiceByBatchNos(@RequestBody List<Long> bathNoList);

    @ApiOperation(value = "根据批次号删除预制发票v2", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/two/delPreInvoiceByBatchNos",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<Integer> delPreInvoiceByBatchNosV2(@RequestBody DeletePreInvoiceByBatchNoRequest request);

    @ApiOperation(value = "根据批次号查询预制发票数量", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/queryPreInvoiceCountByBatchNos",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response queryPreInvoiceCountByBatchNos(@RequestBody List<Long> bathNoList);

    @ApiOperation(value = "保存查询条件", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = Response.class)})
    @RequestMapping(value = "/save-condition",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<String> saveQueryCondition(@ApiParam(value = "流水号") @RequestBody SaveQueryCondtionRequest request);

    @ApiOperation(value = "根据批次号查询预制发票是否在预览中，是否无有效预制发票可重新开票", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = Response.class)})
    @RequestMapping(value = "/bill-item-split-check",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<List<Long>> queryBillItemAllowSplit(@RequestBody QueryBillItemAllowSplitRequest request);

    @ApiOperation(value = "根据批次号查询待开的预制发票", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = Response.class)})
    @RequestMapping(value = "/queryIds/byBatchNos",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<List<Long>> getPreIdsByBatchNos(@RequestBody PreInvoiceSearchRequest request);

    @ApiOperation(value = "预制发票开具", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = Response.class)})
    @RequestMapping(value = "/auto-issue-by-pids",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<String> autoIssueByPidList(@RequestBody AutoIssueRequest request);

    @ApiOperation(value = "红字确认单是否关联了有效的预制发票", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/related/red-confirmation",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<RedConfirmationRelatedPreInvoiceResult> redConfirmationRelatedPreInvoice(@RequestBody RedConfirmationRelatedPreInvoiceRequest request);


    @ApiOperation(value = "查询下一张发票号码代码", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class)})
    @RequestMapping(value = "/queryNextInvoiceInfo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    BaseAsyncResponse queryNextInvoiceInfo(@ApiParam(value = "查询参数") @RequestBody @Validated NextInvoiceRequest nextInvoiceRequest);

    @ApiOperation(value = "查询下一张发票信息状态", notes = "", response = NextInvoiceInfoResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = NextInvoiceInfoResponse.class)})
    @RequestMapping(value = "/queryNextInvoiceInfoStatus",
            produces = {"application/json"},
            method = RequestMethod.POST)
    NextInvoiceInfoResponse queryNextInvoiceInfoStatus(@ApiParam(value = "任务id") @RequestParam(value = "taskId") @NotBlank String taskId);

    @ApiOperation(value = "预览预制发票", notes = "", response = PreviewInvoiceResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = PreviewInvoiceResponse.class)})
    @RequestMapping(value = "/preInvoice/previewInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    PreviewInvoiceResponse previewInvoice(@ApiParam(value = "预制发票Id") @RequestBody PreInvoiceIdParam preInvoiceIdParam);

    @ApiOperation(value = "批量申请红字信息", tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/redLetter/batch-apply",
            produces = {"application/json"},
            method = RequestMethod.POST)
    BaseAsyncResponse batchApplyRedLetter(@ApiParam(value = "预制发票批量申请红字信息请求") @RequestBody BatchApplyRedLetterRequest request);

    @ApiOperation(value = "查询业务单关联的数据情况", tags = {"SellerPreInvoice",})
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = BillIssueSituationDto.ResponseDto.class)})
    @RequestMapping(value = "/query-bill-issue-situation", produces = {"application/json"}, method = RequestMethod.POST)
    BillIssueSituationDto.ResponseDto queryBillIssueSituation(@RequestBody BillIssueSituationDto.RequestDto requestDto);
}
