package com.xforceplus.seller.invoice.client.api.open;

import com.xforceplus.seller.invoice.client.model.open.*;
import com.xforceplus.seller.invoice.client.model.open.v2.invoice.LockInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.open.v2.invoice.LockInvoiceResult;
import com.xforceplus.xplatframework.apimodel.AsyncModel;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "openInvoiceOperation", description = "the sellerPreInvoice API")
public interface OpenInvoiceOperationApi {

    @ApiOperation(value = "根据发票号码代码作废发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/abandon",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response openInvoiceAbandon(@RequestBody OpenInvoiceAbandonRequest request);

    @ApiOperation(value = "根据发票号码代码红冲发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/redflush",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response openInvoiceRedflush(@RequestBody OpenInvoiceRedflushRequest request);

    @ApiOperation(value = "根据发票号码代码红冲发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/buildBizOrderReverseBody",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response buildBizOrderReverseBody(@RequestBody OpenInvoiceRedflushRequest request);

    @ApiOperation(value = "根据发票号码代码红冲发票(不生成业务单,根据发票生成红字预制发票开票)", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/issueRedInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<AsyncModel> openIssueHCRequest(@RequestBody OpenIssueHCRequest request);

    @ApiOperation(value = "根据发票号码代码批量红冲(不生成业务单,根据发票生成红字预制发票开票)", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/batchIssueRedInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response openBatchIssueHcRequest(@RequestBody OpenBatchIssueHCRequest request);

    @ApiOperation(value = "根据业务单号查询发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/queryInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response queryInvoice(@RequestBody QueryInvoiceModel request);

    @ApiOperation(value = "根据预制发票id开具（for TaxWare）", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/issueByPid",
            produces = {"application/json"},
            method = RequestMethod.POST)
    IssueResponse issueByPid(@RequestBody QueryMakeOutResultForTaxWareRequest request);

    @ApiOperation(value = "获取作废结果（标准api）", notes = "", response = OpenResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = OpenResponse.class)})
    @RequestMapping(value = "/open/invoiceOperation/query-abandon-result/{taskId}",
            produces = {"application/json"},
            method = RequestMethod.GET)
    OpenResponse<AsyncTaskReply> queryCancellationResult(@PathVariable("taskId") String taskId);

    @ApiOperation(value = "批量发票锁定/解锁接口[YL10044]", notes = "", response = OpenResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {@ApiResponse(code = 200, message = "结果", response = OpenResponse.class)})
    @RequestMapping(value = "/open/invoiceOperation/lockInvoices", produces = {"application/json"}, method = RequestMethod.POST)
    OpenResponse<LockInvoiceResult> lockInvoices(@RequestBody LockInvoiceRequest request);

    @ApiOperation(value = "根据税号统计待开预制发票（for TaxWare）", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/countByTaxNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response countByTaxNo(@RequestBody QueryTaxNoForPreInvoiceTaxWareRequest request);

    @ApiOperation(value = "发票验真回填", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/back",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response backVerify(@RequestBody InvoiceBackRequest request);

}
