package com.xforceplus.seller.invoice.client.api.open;

import com.xforceplus.seller.invoice.client.model.open.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(value = "openRedLetter")
public interface OpenRedLetterApi {

    @ApiOperation("购销申请红字信息")
    @PostMapping("redletter/task/apply/{userRole}")
    OpenResponse<CommonErrorData> applyRedLetter(@RequestBody OpenApplyRedLetterRequest request, @PathVariable("userRole") Integer userRole);

    @ApiOperation("购销撤销红字信息")
    @PostMapping("redletter/task/cancel-apply")
    OpenResponse<CommonErrorData> cancelApplyRedLetter(@RequestBody CancelApplyRedLetterRequest request);

    @ApiOperation("购销申请红字信息")
    @PostMapping("redletter/task/apply2")
    OpenResponse<CommonErrorData> applyRedLetter(@RequestBody OpenApplyRedLetterV2Request request);

    @ApiOperation("购销撤销红字信息")
    @PostMapping("redletter/task/cancel-apply2")
    OpenResponse<CommonErrorData> cancelApplyRedLetter(@RequestBody CancelApplyRedLetterV2Request request);

}