package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@ApiModel("预制发票批量申请红字校验结果")
@Data
public class BatchApplyRedLetterCheckData {
    @ApiModelProperty("预制发票id集合")
    private List<String> preInvoiceIds;
    @ApiModelProperty("申请累计含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal totalAmountWithTax;
    @ApiModelProperty("申请累计不含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal totalAmountWithoutTax;
    @ApiModelProperty("申请累计税额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal totalTaxAmount;
    @ApiModelProperty("申请总数")
    private Integer total;
    @ApiModelProperty("销方税号")
    private String sellerTaxNo;
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("特殊发票标识")
    private Integer specialInvoiceFlag;
    @ApiModelProperty("国税来源")
    private String taxInvoiceSource;

    public void setPreInvoiceIds(List<String> preInvoiceIds) {
        this.preInvoiceIds = preInvoiceIds;
    }

    public void setTotalAmountWithTax(BigDecimal totalAmountWithTax) {
        this.totalAmountWithTax = totalAmountWithTax;
    }

    public void setTotalAmountWithoutTax(BigDecimal totalAmountWithoutTax) {
        this.totalAmountWithoutTax = totalAmountWithoutTax;
    }

    public void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.totalTaxAmount = totalTaxAmount;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public void setSpecialInvoiceFlag(Integer specialInvoiceFlag) {
        this.specialInvoiceFlag = specialInvoiceFlag;
    }
}
