package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

public class BillIssueSituationDto {

    @Data
    public static class RequestDto {
        private List<String> billIdList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ResponseDto {
        private String code;
        private String message;
        private List<Result> result;

        public static ResponseDto successResult(List<Result> result) {
            return new ResponseDto("1", "成功", result);
        }

        public static ResponseDto failResult(String code, String message) {
            return new ResponseDto(code, message, null);
        }

        @Data
        @AllArgsConstructor
        @NoArgsConstructor
        public static class Result {
            @JsonFormat(shape = JsonFormat.Shape.STRING)
            private Long billId;
            /**
             * 发票集合
             */
            private List<Invoice> invoiceList;
            /**
             * 预制发票集合，里面有没开/开具中/开具失败的预制发票
             */
            private List<PreInvoice> preInvoiceList;

            @Data
            public static class Invoice {
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private Long id;
                private String invoiceNo;
                private String invoiceCode;
                private String allElectricInvoiceNo;
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private BigDecimal amountWithTax;
                private Integer redFlag;
                private Integer status;
                private List<InvoiceRelation> relation;
            }

            @Data
            public static class InvoiceRelation {
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private Long invoiceId;
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private Long invoiceItemId;
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private Long billId;
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private Long billItemId;
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private BigDecimal amountWithTax;
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private BigDecimal amountWithoutTax;
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private BigDecimal taxAmount;
            }

            @Data
            public static class PreInvoice {
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private Long id;
                private Integer status;
                @JsonFormat(shape = JsonFormat.Shape.STRING)
                private BigDecimal amountWithTax;
                private String processFlag;
                private String processRemark;
                private boolean canRetry;
            }
        }
    }
}
