package com.xforceplus.seller.invoice.client.model;


import lombok.Data;

import java.math.BigDecimal;

@Data
public class DetailInfo {

    //预制发票id
    private Long preInvoiceId;

    //单据id
    private Long salesBillId;

    //单据明细id
    private Long salesBillItemId;

    //不含税金额
    private BigDecimal amountWithoutTax;

    //税额
    private BigDecimal taxAmount;

    //含税金额
    private BigDecimal amountWithTax;

    //价外含税折扣
    private BigDecimal outterDiscountWithTax;

    //价外不含税折扣
    private BigDecimal outterDiscountWithoutTax;

    //价外折扣税额
    private BigDecimal outterDiscountTax;

    //价内含税折扣
    private BigDecimal innerDiscountWithTax;

    //价内不含税折扣
    private BigDecimal innerDiscountWithoutTax;

    //价内折扣税额
    private BigDecimal innerDiscountTax;

    //价外预付卡含税金额
    private BigDecimal outterPrepayAmountWithTax;

    //价外预付卡不含税金额
    private BigDecimal outterPrepayAmountWithoutTax;

    //价外预付卡税额
    private BigDecimal outterPrepayAmountTax;

    //价内预付卡含税金额
    private BigDecimal innerPrepayAmountWithTax;

    //价内预付卡不含税金额
    private BigDecimal innerPrepayAmountWithoutTax;

    //价内预付卡税额
    private BigDecimal innerPrepayAmountTax;

    /**
     * 折扣不含税金额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : discount_without_tax
     */
    private BigDecimal discountWithoutTax;

    /**
     * 折扣含税金额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : discount_with_tax
     */
    private BigDecimal discountWithTax;

    /**
     * 折扣税额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : discount_tax
     */
    private BigDecimal discountTax;

    //折扣率
    private BigDecimal discountRate;
}
