package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * ExportInvoicePDFResponse
 */

@JsonInclude(NON_NULL)
public class ExportInvoicePDFResponse {
  @JsonProperty("code")
  private Integer code = 1;

  @JsonProperty("message")
  private String message = "获取成功!";

  @JsonProperty("asyncFlag")
  private Integer asyncFlag = 0;

  @JsonProperty("result")
  private List<ExportPDFResult> result = null;

  @JsonIgnore
  public ExportInvoicePDFResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @ApiModelProperty(value = "")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public ExportInvoicePDFResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public ExportInvoicePDFResponse result(List<ExportPDFResult>  result) {
    this.result = result;
    return this;
  }

   /**
   * 发票详细信息
   * @return result
  **/
  @ApiModelProperty(value = "发票详细信息")
  public List<ExportPDFResult>  getResult() {
    return result;
  }

  public void setResult(List<ExportPDFResult>  result) {
    this.result = result;
  }
  public Integer getAsyncFlag() {
    return asyncFlag;
  }

  public void setAsyncFlag(Integer asyncFlag) {
    this.asyncFlag = asyncFlag;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExportInvoicePDFResponse response = (ExportInvoicePDFResponse) o;
    return Objects.equals(this.code, response.code) &&
            Objects.equals(this.asyncFlag, response.asyncFlag) &&
        Objects.equals(this.message, response.message) &&
        Objects.equals(this.result, response.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code,asyncFlag, message, result);
  }



  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExportInvoicePDFResponse {\n");

    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    asyncFlag: ").append(toIndentedString(asyncFlag)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
