package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * HasStoreIssuedInvoiceResponse
 */

@JsonInclude(NON_NULL)
public class HasStoreIssuedInvoiceResponse {
  @JsonProperty("code")
  private Integer code = 1;

  @JsonProperty("message")
  private String message = "获取成功!";

  @JsonProperty("result")
  private List<HasInvoiceDTO> result = null;

  @JsonIgnore
  public HasStoreIssuedInvoiceResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @ApiModelProperty(value = "")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public HasStoreIssuedInvoiceResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public HasStoreIssuedInvoiceResponse result(List<HasInvoiceDTO> result) {
    this.result = result;
    return this;
  }

   /**
   * 提供根据门店+日期查询是否直连开票的能力
    * 是否开票结果
   * @return result
  **/
  @ApiModelProperty(value = "是否开票结果")
  public List<HasInvoiceDTO> getResult() {
    return result;
  }

  public void setResult(List<HasInvoiceDTO> result) {
    this.result = result;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HasStoreIssuedInvoiceResponse sellerInvoiceQueryResponse = (HasStoreIssuedInvoiceResponse) o;
    return Objects.equals(this.code, sellerInvoiceQueryResponse.code) &&
        Objects.equals(this.message, sellerInvoiceQueryResponse.message) &&
        Objects.equals(this.result, sellerInvoiceQueryResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HasStoreIssuedInvoiceResponse {\n");

    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
