package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票明细信息分页返回结果
 */
@ApiModel(description = "发票明细信息分页返回结果")
@JsonInclude(NON_NULL)
@Data
@NoArgsConstructor
@AllArgsConstructor
public class InvoiceItemPageQueryResult {
  @JsonProperty("total")
  private Long total = null;
  @JsonProperty("list")
  private List<InvoiceItem> list = new ArrayList<InvoiceItem>();

}
