package com.xforceplus.seller.invoice.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;

/**
 * @author adnis
 */
@ApiModel(description = "发票详情--包含发票详情信息、发票明细列表信息、发票操作日志列表信息")

@JsonInclude(NON_NULL)
@Data
public class InvoiceOpenDetails {
    @JsonProperty("invoiceInfo")
    private SellerInvoiceOpenInfo invoiceInfo = null;
    @JsonProperty("invoiceItemList")
    private List<InvoiceOpenItem> invoiceItemList = new ArrayList<InvoiceOpenItem>();
}