package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

@ApiModel("发票通用查询")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class InvoiceQueryRequest {
    @ApiModelProperty("查询条件")
    private Conditions conditions;
    @ApiModelProperty("是否全选 1-全选 0-非全选")
    private Boolean isAllSelected;
    @ApiModelProperty("包含的id集合")
    private List<Long> includes = new ArrayList<>();
    @ApiModelProperty("排除的id集合")
    private List<Long> excludes = new ArrayList<>();
    @ApiModelProperty("用户角色")
    private Integer userRole;
    @ApiModelProperty("是否忽略token中的租户信息")
    private Boolean ignoreTokenTenant;
    @ApiModelProperty("销方租户id，基本要配合 ignoreTokenTenant=true 使用")
    private Long sellerGroupId;
}
