package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsApplyForRedNoRequest {
  @JsonProperty("redNotification")
  private List<MsSysRedNoImportDto> redNotification = new ArrayList<MsSysRedNoImportDto>();

  @JsonIgnore
  public MsApplyForRedNoRequest redNotification(List<MsSysRedNoImportDto> redNotification) {
    this.redNotification = redNotification;
    return this;
  }

  public MsApplyForRedNoRequest addRedNotificationItem(MsSysRedNoImportDto redNotificationItem) {
    this.redNotification.add(redNotificationItem);
    return this;
  }

   /**
   * 详情
   * @return redNotification
  **/
  @ApiModelProperty(value = "详情")
  public List<MsSysRedNoImportDto> getRedNotification() {
    return redNotification;
  }

  public void setRedNotification(List<MsSysRedNoImportDto> redNotification) {
    this.redNotification = redNotification;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsApplyForRedNoRequest applyForRedNoRequest = (MsApplyForRedNoRequest) o;
    return Objects.equals(this.redNotification, applyForRedNoRequest.redNotification);
  }

  @Override
  public int hashCode() {
    return Objects.hash(redNotification);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsApplyForRedNoRequest {\n");

    sb.append("    redNotification: ").append(toIndentedString(redNotification)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
