package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 基础打印发票结果
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "基础打印发票结果")

@JsonInclude(NON_NULL)
@Data
public class PollingBasePrintInvoiceResult extends PollingModel {

    @JsonProperty("basePrintInvoiceResult")
    BasePrintInvoiceResult basePrintInvoiceResult = null;
    //为兼容单张返回逻辑
    @ApiModelProperty(value = "打印销货清单失败总数")
    private int failedCount = 0;
    @ApiModelProperty(value = "打印销货清单成功总数")
    private int successCount = 0;
    @ApiModelProperty(value = "发票打印总数")
    private int printTotal = 0;
    @ApiModelProperty(value = "是否单张返回")
    private Boolean singleReturn = false;
//    /**
//     * Get basePrintInvoiceResult
//     *
//     * @return basePrintInvoiceResult
//     **/
//    @ApiModelProperty(value = "")
//    public BasePrintInvoiceResult getBasePrintInvoiceResult() {
//        return basePrintInvoiceResult;
//    }
//
//    public void setBasePrintInvoiceResult(BasePrintInvoiceResult basePrintInvoiceResult) {
//        this.basePrintInvoiceResult = basePrintInvoiceResult;
//    }
}
