package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 打印发票或者销货清单结果
 */
@ApiModel(description = "打印发票或者销货清单结果")
@JsonInclude(NON_NULL)
@Data
public class PollingPrintInvoiceResult extends PollingModel {

    @ApiModelProperty(value = "发票打印失败总数")
    private int invoiceFailedCount = 0;

    @ApiModelProperty(value = "发票打印成功总数")
    private int invoiceSuccessCount = 0;
    @ApiModelProperty(value = "发票打印总数")
    private int invoiceTotal;

    @ApiModelProperty(value = "是否包含销货清单打印 0-不包含 1-包含")
    private String containSellList = "0";

    @ApiModelProperty(value = "打印失败总数")
    private int sellListFailedCount = 0;

    @ApiModelProperty(value = "销货清单打印成功总数")
    private int sellListSuccessCount = 0;

    @ApiModelProperty(value = "是否单张返回true：是 false 否")
    private boolean singleReturn = false;

    @ApiModelProperty(value = "销货清总数")
    private int salesListTotal;
}
