package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * PreInvoiceIdList
 */

@JsonInclude(NON_NULL)
public class PreInvoiceId {
  @JsonProperty("preInvoiceId")
  private Long preInvoiceId = null;

  @JsonIgnore
  public PreInvoiceId preInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
    return this;
  }

   /**
   * 预制发票id
   * @return preInvoiceId
  **/
  @ApiModelProperty(value = "预制发票id")
  public Long getPreInvoiceId() {
    return preInvoiceId;
  }

  public void setPreInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    PreInvoiceId that = (PreInvoiceId) o;

    return preInvoiceId != null ? preInvoiceId.equals(that.preInvoiceId) : that.preInvoiceId == null;
  }

  @Override
  public int hashCode() {
    return preInvoiceId != null ? preInvoiceId.hashCode() : 0;
  }

  @Override
  public String toString() {
    return "PreInvoiceId{" +
            "preInvoiceId=" + preInvoiceId +
            '}';
  }
}
