package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
@ApiModel(description = "预制发票总金额,原单itemId集合")
public class PreInvoiceOriginalSalesDetailResponse {

    @JsonProperty("code")
    @ApiModelProperty(value = "code")
    private Integer code = 1;

    @JsonProperty("message")
    @ApiModelProperty(value = "message")
    private String message = "获取成功!";

    @JsonProperty("amountWithTaxTotal")
    @ApiModelProperty(value = "预制发票含税总金额")
    private List<PreInvoiceOriginalSalesDetailAmountInfo> preInvoiceOriginalSalesDetailAmountInfoList;


    @JsonIgnore
    public PreInvoiceOriginalSalesDetailResponse code(Integer code) {
        this.code = code;
        return this;
    }

    @JsonIgnore
    public PreInvoiceOriginalSalesDetailResponse message(String message) {
        this.message = message;
        return this;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<PreInvoiceOriginalSalesDetailAmountInfo> getPreInvoiceOriginalSalesDetailAmountInfoList() {
        return preInvoiceOriginalSalesDetailAmountInfoList;
    }

    public void setPreInvoiceOriginalSalesDetailAmountInfoList(List<PreInvoiceOriginalSalesDetailAmountInfo> preInvoiceOriginalSalesDetailAmountInfoList) {
        this.preInvoiceOriginalSalesDetailAmountInfoList = preInvoiceOriginalSalesDetailAmountInfoList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PreInvoiceOriginalSalesDetailResponse that = (PreInvoiceOriginalSalesDetailResponse) o;

        if (getCode() != null ? !getCode().equals(that.getCode()) : that.getCode() != null) return false;
        if (getMessage() != null ? !getMessage().equals(that.getMessage()) : that.getMessage() != null) return false;
        return getPreInvoiceOriginalSalesDetailAmountInfoList() != null ? getPreInvoiceOriginalSalesDetailAmountInfoList().equals(that.getPreInvoiceOriginalSalesDetailAmountInfoList()) : that.getPreInvoiceOriginalSalesDetailAmountInfoList() == null;
    }

    @Override
    public int hashCode() {
        int result = getCode() != null ? getCode().hashCode() : 0;
        result = 31 * result + (getMessage() != null ? getMessage().hashCode() : 0);
        result = 31 * result + (getPreInvoiceOriginalSalesDetailAmountInfoList() != null ? getPreInvoiceOriginalSalesDetailAmountInfoList().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PreInvoiceOriginalSalesDetailResponse{" +
                "code=" + code +
                ", message='" + message + '\'' +
                ", preInvoiceOriginalSalesDetailAmountInfoList=" + preInvoiceOriginalSalesDetailAmountInfoList +
                '}';
    }
}
