package com.xforceplus.seller.invoice.client.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票信息
 */
@ApiModel(description = "预制发票信息")

@JsonInclude(NON_NULL)
@Data
public class PreInvoicePolling {
    @JsonProperty("id")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long id = null;

    @JsonProperty("batchNo")
    private Long batchNo = null;

    @JsonProperty("sellerTenantId")
    private String sellerTenantId = null;

    @JsonProperty("sellerGroupId")
    private String sellerGroupId = null;

    @JsonProperty("sellerNo")
    private String sellerNo = null;

    @JsonProperty("sellerCode")
    private String sellerCode = null;

    @JsonProperty("sellerName")
    private String sellerName = null;

    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;

    @JsonProperty("sellerTel")
    private String sellerTel = null;

    @JsonProperty("sellerAddress")
    private String sellerAddress = null;

    @JsonProperty("sellerBankName")
    private String sellerBankName = null;

    @JsonProperty("sellerBankAccount")
    private String sellerBankAccount = null;

    @JsonProperty("purchaserName")
    private String purchaserName = null;

    @JsonProperty("purchaserTenantId")
    private String purchaserTenantId = null;

    @JsonProperty("purchaserGroupId")
    private String purchaserGroupId = null;

    @JsonProperty("purchaserCode")
    private String purchaserCode = null;

    @JsonProperty("purchaserNo")
    private String purchaserNo = null;

    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo = null;

    @JsonProperty("purchaserTel")
    private String purchaserTel = null;

    @JsonProperty("purchaserAddress")
    private String purchaserAddress = null;

    @JsonProperty("purchaserBankName")
    private String purchaserBankName = null;

    @JsonProperty("purchaserBankAccount")
    private String purchaserBankAccount = null;

    @JsonProperty("invoiceType")
    private String invoiceType = null;

    @JsonProperty("businessBillType")
    private String businessBillType = null;

    @JsonProperty("salesbillType")
    private String salesbillType = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("machineCode")
    private String machineCode = null;

    @JsonProperty("paperDrawDate")
    private String paperDrawDate = null;

    @JsonProperty("checkCode")
    private String checkCode = null;

    @JsonProperty("cashierName")
    private String cashierName = null;

    @JsonProperty("checkerName")
    private String checkerName = null;

    @JsonProperty("invoicerName")
    private String invoicerName = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("electronicSignature")
    private String electronicSignature = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("cipherText")
    private String cipherText = null;

    @JsonProperty("cipherTextTwoCode")
    private String cipherTextTwoCode = null;

    @JsonProperty("saleListFileFlag")
    private Integer saleListFileFlag = null;

    @JsonProperty("taxRateStr")
    private String taxRateStr = null;

    @JsonProperty("taxAmountStr")
    private String taxAmountStr = null;

    @ApiModelProperty("特殊发票标记  0-默认  1-通行费   2-成品油")
    private String specialInvoiceFlag;

    @JsonProperty("originInvoiceNo")
    private String originInvoiceNo = null;

    @JsonProperty("originInvoiceCode")
    private String originInvoiceCode = null;

    @JsonProperty("redNotificationNo")
    private String redNotificationNo = null;

    @JsonProperty("originInvoiceType")
    private String originInvoiceType;

    @JsonProperty("originPaperDrawDate")
    private String originPaperDrawDate;

    @Getter
    @Setter
    @ApiModelProperty("开具原因")
    private String makingReason;

    private String taxInvoiceSource;

    private String invoiceKind;

    @JsonProperty("purchaserType")
    private String purchaserType = null;

    @JsonProperty("specialAdditions")
    private List<Map<String, Object>> specialAdditions;
}
