package com.xforceplus.seller.invoice.client.model;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.math.BigDecimal;

@ApiModel(description = "单据明细信息")
@ToString
@EqualsAndHashCode
@Data
public class PreInvoiceVo {

    @ApiModelProperty(value = "发票号码")
    public String invoiceNo;

    @ApiModelProperty(value = "发票代码")
    public String invoiceCode;

    @ApiModelProperty(value = "发票类型")
    public String invoiceType;

    @ApiModelProperty(value = "业务单类型")
    public String billType;

    @ApiModelProperty(value = "数电发票代码")
    public String allElectricInvoiceNo;

    @ApiModelProperty(value = "预制发票Id")
    public Long preInvoiceId;

    @ApiModelProperty(value = "开票时间")
    public String dateIssued;

    @ApiModelProperty(value = "开票人")
    public String invoiceName;

    @ApiModelProperty(value = "状态")
    public Integer status;

    @ApiModelProperty(value = "发票状态 1正常 2已作废 3-已红冲, 4-已部分红冲, 5-红冲票")
    public Integer invoiceStatus;

    @ApiModelProperty(value = "不含税金额")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "价税合计")
    private BigDecimal amountWithTax;

    /**
     * 0-正常, 1-待红冲, 2-待部分红冲, 3-已红冲, 4-已部分红冲, 5-红冲票
     * 表 : inv_seller_invoice
     * 对应字段 : red_flag
     */
    @ApiModelProperty(value = "红冲状态")
    private Integer redFlag;

    @ApiModelProperty(value = "开具失败原因")
    public String process_remark;
}