package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * QuerySaleItemIdsByInvoiceResponse
 */

@JsonInclude(NON_NULL)
public class QuerySaleItemIdsByInvoiceResponse {

    @JsonProperty("code")
    private Integer code = 1;

    @JsonProperty("message")
    private String message = "调用成功";

    @JsonProperty("result")
    private QuerySaleItemIdsByInvoiceResult result = null;

    @JsonIgnore
    public QuerySaleItemIdsByInvoiceResponse code(Integer code) {
      this.code = code;
      return this;
    }

     /**
     * Get code
     * @return code
    **/
    @ApiModelProperty(value = "")
    public Integer getCode() {
      return code;
    }

    public void setCode(Integer code) {
      this.code = code;
    }

    @JsonIgnore
    public QuerySaleItemIdsByInvoiceResponse message(String message) {
      this.message = message;
      return this;
    }

     /**
     * Get message
     * @return message
    **/
    @ApiModelProperty(value = "")
    public String getMessage() {
      return message;
    }

    public void setMessage(String message) {
      this.message = message;
    }

    @JsonIgnore
    public QuerySaleItemIdsByInvoiceResponse result(QuerySaleItemIdsByInvoiceResult result) {
      this.result = result;
      return this;
    }

     /**
     * 发票详细信息
     * @return result
    **/
    @ApiModelProperty(value = "拆票详细结果")
    public Object getResult() {
      return result;
    }

    public void setResult(QuerySaleItemIdsByInvoiceResult result) {
      this.result = result;
    }


    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }
      QuerySaleItemIdsByInvoiceResponse splitInvoiceResponse = (QuerySaleItemIdsByInvoiceResponse) o;
      return Objects.equals(this.code, splitInvoiceResponse.code) &&
          Objects.equals(this.message, splitInvoiceResponse.message) &&
          Objects.equals(this.result, splitInvoiceResponse.result);
    }

    @Override
    public int hashCode() {
      return Objects.hash(code, message, result);
    }


    @Override
    public String toString() {
      StringBuilder sb = new StringBuilder();
      sb.append("class InvoiceDetailsInfoResponse {\n");

      sb.append("    code: ").append(toIndentedString(code)).append("\n");
      sb.append("    message: ").append(toIndentedString(message)).append("\n");
      sb.append("    result: ").append(toIndentedString(result)).append("\n");
      sb.append("}");
      return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
      if (o == null) {
        return "null";
      }
      return o.toString().replace("\n", "\n    ");
    }

}
