package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@Data
@JsonInclude(NON_NULL)
public class QuerySellerInvoiceDetailsRequest {
  @JsonProperty("invoiceId")
  private Long invoiceId;
  @JsonProperty("invoiceNo")
  private String invoiceNo;
  @JsonProperty("invoiceCode")
  private String invoiceCode;
  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo;
  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode;
  @JsonProperty("allElectricInvoiceNo")
  private String allElectricInvoiceNo;
  @JsonProperty("queryItem")
  private boolean queryItem;
  @ApiModelProperty("租户id")
  @JsonFormat(shape = JsonFormat.Shape.STRING)
  private Long sellerGroupId;
}
