package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * RedflushSellerInvoiceCheckRequest
 */

@JsonInclude(NON_NULL)
@Data
public class RedflushSellerInvoiceCheckRequest {
    @JsonProperty("conditions")
    private Conditions conditions = null;

    @JsonProperty("isAllSelected")
    private Boolean isAllSelected = null;

    @JsonProperty("includes")
    private List<Long> includes = new ArrayList<Long>();

    @JsonProperty("excludes")
    private List<Long> excludes = new ArrayList<Long>();

    @JsonProperty("deviceId")
    private Long deviceId = null;

    @JsonProperty("mip")
    private String mip = null;

    @JsonProperty("mode")
    private String mode = null;

    @JsonProperty("nextInvoiceNo")
    private String nextInvoiceNo = null;

    @JsonProperty("nextInvoiceCode")
    private String nextInvoiceCode = null;

    @JsonProperty("invoicerName")
    private String invoicerName = null;

    @JsonProperty("tenantNo")
    private String tenantNo = null;

    @JsonProperty("companyId")
    private String companyId = null;

    @JsonProperty("redNotificationNo")
    private String redNotificationNo = null;

    @JsonProperty("redFlushModel")
    private Integer redFlushModel = null;

    @JsonProperty("reason")
    private String reason = null;


    private Integer status = null;

    private String operateType;

    private String redInvoiceType;

    @ApiModelProperty("是否在预警后继续（二次确认场景使用）")
    private Boolean afterAlertContinue;

}
