package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 查询条件集合
 */
@ApiModel(description = "查询条件集合")

@JsonInclude(NON_NULL)
public class SalesInvoiceRequestFieldList {
  @JsonProperty("requestFieldList")
  private List<RequestField> requestFieldList = new ArrayList<RequestField>();

  @JsonIgnore
  public SalesInvoiceRequestFieldList requestFieldList(List<RequestField> requestFieldList) {
    this.requestFieldList = requestFieldList;
    return this;
  }

  public SalesInvoiceRequestFieldList addRequestFieldListItem(RequestField requestFieldListItem) {
    this.requestFieldList.add(requestFieldListItem);
    return this;
  }

   /**
   * Get requestFieldList
   * @return requestFieldList
  **/
  @ApiModelProperty(value = "")
  public List<RequestField> getRequestFieldList() {
    return requestFieldList;
  }

  public void setRequestFieldList(List<RequestField> requestFieldList) {
    this.requestFieldList = requestFieldList;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalesInvoiceRequestFieldList salesInvoiceRequestFieldList = (SalesInvoiceRequestFieldList) o;
    return Objects.equals(this.requestFieldList, salesInvoiceRequestFieldList.requestFieldList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestFieldList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalesInvoiceRequestFieldList {\n");

    sb.append("    requestFieldList: ").append(toIndentedString(requestFieldList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
