package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 机动车发票信息
 */
@ApiModel(description = "机动车发票信息")

@JsonInclude(NON_NULL)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SellerInvoiceVehicleInfo {

    @JsonProperty("invoiceId")
    private Long invoiceId = null;

    @JsonProperty("manufacturerName")
    private String manufacturerName = null;

    @JsonProperty("vehicleType")
    private String vehicleType = null;

    @JsonProperty("vehicleBrand")
    private String vehicleBrand = null;

    @JsonProperty("productionArea")
    private String productionArea = null;

    @JsonProperty("certificationNo")
    private String certificationNo = null;

    @JsonProperty("importCertificateNo")
    private String importCertificateNo = null;

    @JsonProperty("commodityInspectionNo")
    private String commodityInspectionNo = null;

    @JsonProperty("engineNo")
    private String engineNo = null;

    @JsonProperty("vehicleNo")
    private String vehicleNo = null;

    @JsonProperty("tonnage")
    private String tonnage = null;

    @JsonProperty("maxCapacity")
    private String maxCapacity = null;

    @JsonProperty("taxPaidProof")
    private String taxPaidProof = null;

    @JsonProperty("identificationId")
    private String identificationId = null;

    @JsonProperty("storeNo")
    private String storeNo = null;

    @JsonProperty("vehicleSellerTel")
    private String vehicleSellerTel = null;

    @JsonProperty("ext1")
    private String ext1 = null;

    @JsonProperty("ext2")
    private String ext2 = null;

    @JsonProperty("printedCode")
    private String printedCode = null;

    @JsonProperty("printedNo")
    private String printedNo = null;

    @JsonProperty("chargeTaxAuthorityName")
    private String chargeTaxAuthorityName = null;

    @JsonProperty("chargeTaxAuthorityCode")
    private String chargeTaxAuthorityCode = null;

    @JsonProperty("purchaseTaxInfo")
    private String purchaseTaxInfo = null;

    private Integer credentialType = null;

    private String goodsTaxNo;
}
