package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * SellerPreInvoiceQueryByConditionRequest
 */

@JsonInclude(NON_NULL)
@Data
public class SellerPreInvoiceQueryByConditionRequest {
  @JsonProperty("pageNo")
  @Min(value = 1, message = "页码不能小于1")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  @Min(value = 1, message = "每页数据不能小于1")
  private Integer pageSize = null;

  @JsonProperty("status")
  @NotBlank(message = "状态不能为空")
  private String status = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("sort")
  List<Sort> sort = null;

  @ApiModelProperty("搜索查询范围")
  private List<Long> createTime;

  @JsonProperty("groups")
  private List<List<RequestField>> groups = new ArrayList<List<RequestField>>();

  @ApiModelProperty("查询来源 协同-90 ")
  private String requestSource;
  @ApiModelProperty("是否带权限查询 带权限-（true 或 null） 不带权限-false")
  private Boolean queryWithAuth;
}
