package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 单据参数
 */
@ApiModel
public class SplitBillParam {

    @ApiModelProperty("待拆分单据信息")
    @NotEmpty(message = "单据信息不能为空")
    private List<OrderInfo> orderInfoList;

    @ApiModelProperty("拆票规则")
    @NotNull(message = "拆票规则不能为空")
    private SplitRule splitRule;

    @ApiModelProperty("是否是服务器模式")
    private boolean isServerType;


    public List<OrderInfo> getOrderInfoList() {
        return orderInfoList;
    }

    public void setOrderInfoList(List<OrderInfo> orderInfoList) {
        this.orderInfoList = orderInfoList;
    }

    public SplitRule getSplitRule() {
        return splitRule;
    }

    public void setSplitRule(SplitRule splitRule) {
        this.splitRule = splitRule;
    }

    public boolean isServerType() {
        return isServerType;
    }

    public void setServerType(boolean serverType) {
        isServerType = serverType;
    }

    @Override
    public String toString() {
        return "SplitBillParam{" +
                "orderInfoList=" + orderInfoList +
                ", splitRule=" + splitRule +
                ", isServerType=" + isServerType +
                '}';
    }
}
