package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 拆票明细的关联关系（仅在不调用拆票服务时起作用）
 */
@Data
public class SplitItemRelationVo implements Serializable {
    @ApiModelProperty("发起拆票操作的明细id，只对应1条预制发票明细")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long splitItemId;
    @ApiModelProperty("单据明细id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long billItemId;
    @ApiModelProperty("单据明细占用的不含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal amountWithoutTax;
    @ApiModelProperty("单据明细占用的税额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal taxAmount;
    @ApiModelProperty("单据明细占用的不含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal amountWithTax;
}
