package com.xforceplus.seller.invoice.client.model.invoice;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author : hujintao
 * @version : 1.0
 * @description : 发票非直连红冲请求 - 单张
 * @date : 2023/06/15
 **/
@ApiModel("发票非直连红冲请求参数-单张")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RedFlushInvoiceNoDirectRequest {


    @ApiModelProperty("蓝票id")
    @JsonProperty("blueInvoiceId")
    private Long blueInvoiceId = null;

    @ApiModelProperty("红冲票发票号码")
    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @ApiModelProperty("红冲票发票代码")
    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @ApiModelProperty("红冲票数电纸票发票号码")
    @JsonProperty("paperInvoiceNo")
    private String paperInvoiceNo = null;

    @ApiModelProperty("红冲票数电纸票发票代码")
    @JsonProperty("paperInvoiceCode")
    private String paperInvoiceCode = null;

    @ApiModelProperty("红冲票不含税金额")
    @JsonProperty("amountWithoutTax")
    private String amountWithoutTax = null;

    @ApiModelProperty("红冲票含税金额")
    @JsonProperty("amountWithTax")
    private String amountWithTax = null;

    @ApiModelProperty("红冲票开票日期")
    @JsonProperty("paperDrewDate")
    private String paperDrewDate = null;

    @ApiModelProperty("红冲票校验码")
    @JsonProperty("checkCode")
    private String checkCode = null;

    @ApiModelProperty("红字信息表编号/红字确认单编号")
    @JsonProperty("redNotificationNo")
    private String redNotificationNo = null;

    @ApiModelProperty("红冲票发票类型")
    @JsonProperty("invoiceType")
    private String invoiceType = null;

    @ApiModelProperty("开票人")
    @JsonProperty("issuer")
    private String issuer = null;

    @ApiModelProperty("释放类型")
    @JsonProperty("releaseType")
    private Integer releaseType = null;

    @ApiModelProperty("红冲的原因")
    @JsonProperty("reason")
    private String reason = null;

    @ApiModelProperty("任务id")
    @JsonProperty("taskId")
    private Long taskId = null;

    @ApiModelProperty("红票的国税发票来源，数电红冲税控必填")
    private String redTaxInvoiceSource;
}
