package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("撤销红字信息请求")
public class CancelApplyRedLetterV2Request {
    @ApiModelProperty("终端唯一码")
    private String terminalUn;

    @ApiModelProperty("设备唯一码")
    @NotNull(message = "deviceUn参数为必填项")
    private String deviceUn;

    @ApiModelProperty("红字信息编号")
    private List<String> redLetterNumbers;
}
