package com.xforceplus.seller.invoice.client.model.update;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.client.model.InvoiceDetails;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "发票更新条件信息")
@Data
@JsonInclude(NON_NULL)
public class InvoiceAddRequest {
    @JsonProperty("sellerGroupId")
    @ApiModelProperty("销方集团Id")
    private Long sellerGroupId = null;

    @ApiModelProperty("更新发票list")
    @JsonProperty("invoiceList")
    private List<InvoiceDetails> invoiceList = null;

    @ApiModelProperty("操作类型(0:主信息+明细保存,1:单独主信息保存,2:单独明细保存)")
    @JsonProperty("opType")
    private Integer opType = 0;

    /**
     * 操作来源
     */
    @JsonProperty("source")
    private String source;

}
