package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.maintenance.model.FiltersConditionRequest;
import com.xforceplus.maintenance.model.GroupFiltersConditionRequest;
import com.xforceplus.seller.invoice.client.model.QueryMakeOutFailResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/25 17:37
 */
@Api(value = "AutoMakeOutMaintenanceApi", description = "the auto make out fail API")
public interface AutoMakeOutMaintenanceApi {


    @ApiOperation(value = "查询自动开具失败接口", notes = "", response = QueryMakeOutFailResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"Maintenance",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "自动开具失败的预制发票", response = QueryMakeOutFailResponse.class)})
    @RequestMapping(value = "/pre-invoice/query-make-out-fail-list",
            produces = {"application/json"},
            method = RequestMethod.POST)
    QueryMakeOutFailResponse queryMakeOutFailList(@ApiParam(value = "查询请求", required = true) @RequestBody GroupFiltersConditionRequest request);

    @ApiOperation(value = "重新发起开具", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"Maintenance",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "自动开具失败的预制发票", response = Response.class)})
    @RequestMapping(value = "/pre-invoice/resend-make-out-request",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response resendMakeOutRequest(@ApiParam(value = "查询请求", required = true) @RequestBody List<Long> requestIdList);
}
