package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.PreInvoiceOriginalSalesDetailQueryRequest;
import com.xforceplus.seller.invoice.client.model.PreInvoiceOriginalSalesDetailResponse;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 项目名称:  phoenix-seller-invoice
 * 模块名称:
 * 说明:
 * JDK 版本: JDK1.8
 *
 * @author 作者：chenqiguang
 * 创建日期：2019-02-28
 */
@Api(value = "preInvoiceToBill", description = "the preInvoiceToBill API")
public interface PreInvoiceToBillApi {

    @ApiOperation(value = "按批次号批量删除预制发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "SellerPreInvoiceToBill", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/preInvoice/deleteByBatchNo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response deletePreInvoiceByBatchNo(@ApiParam(value = "按批次号删除预制发票信息", required = true) @RequestBody List<Long> batchNos);

    @ApiOperation(value = "根据业务单id查询预制发票总金额", notes = "", response = SellerPreInvoiceResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = SellerPreInvoiceResponse.class)})
    @RequestMapping(value = "/preInvoice/queryAmountWithTaxTotalBySalesbillId",
            produces = {"application/json"},
            method = RequestMethod.POST)
    SellerPreInvoiceResponse queryAmountWithTaxTotalBySalesbillId(@ApiParam(value = "发票查询请求") @RequestBody SellerPreInvoiceRequest sellerPreInvoiceRequest);

    @ApiOperation(value = "根据业务原明细Id 查 原始明细Id在预制发票中的站比金额", notes = "", response = SellerPreInvoiceResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = SellerPreInvoiceResponse.class)})
    @RequestMapping(value = "/preInvoice/queryS",
            produces = {"application/json"},
            method = RequestMethod.POST)
    PreInvoiceOriginalSalesDetailResponse queryAmountWithTaxTotalBySourceSalesbillItemIdList(@ApiParam(value = "明细金额占比请求") @RequestBody PreInvoiceOriginalSalesDetailQueryRequest preInvoiceOriginalSalesDetailQueryRequest);

}
