package com.xforceplus.seller.invoice.client.api.update;

import com.xforceplus.seller.invoice.client.model.update.BatchUpdateRequest;
import com.xforceplus.seller.invoice.client.model.update.InvoiceAddRequest;
import com.xforceplus.seller.invoice.client.model.update.InvoiceUpdateRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "updateInvoice", description = "the sellerInvoice API")
public interface UpdateInvoiceApi {

    @ApiOperation(value = "更新发票信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"updateInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/invoice/action/batch-update",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updateInvoiceList(@RequestBody InvoiceUpdateRequest updateInvoiceRequest);

    @ApiOperation(value = "更新和与预制发票发票信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"updateInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/invoice/action/batch/update",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updateInvoiceBatch(@RequestBody BatchUpdateRequest updateRequest);

    @ApiOperation(value = "新增发票信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"saveInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/invoice/action/batch-insert",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response saveInvoiceList(@RequestBody InvoiceAddRequest request);
}
