package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class BackFillRelationData {
    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("单据id")
    private Long salesbillId;
    @ApiModelProperty("状态")
    private Integer status;
    @ApiModelProperty("发票号码")
    private String invoiceNo;
    @ApiModelProperty("发票代码")
    private String invoiceCode;
    @ApiModelProperty("数电发票号码")
    private String allElectricInvoiceNo;
    @ApiModelProperty("开票日期")
    private Date paperDrawDate;
    @ApiModelProperty("不含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal amountWithoutTax;
    @ApiModelProperty("含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal amountWithTax;
    @ApiModelProperty("税额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal taxAmount;
    @ApiModelProperty("发票票种")
    private String invoiceKind;
    @ApiModelProperty("校验码")
    private String checkCode;
    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource;
    @ApiModelProperty("错误原因")
    private String processRemark;
}
