package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
public class BatchAbandonAndReverseResult extends PollingModel {
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @ApiModelProperty("红冲成功数量")
    private Integer successReverseCount;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @ApiModelProperty("红冲失败数量")
    private Integer failReverseCount;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @ApiModelProperty("红冲总数")
    private Integer reverseTotal;
    private List<String> failQdReversePreIdList;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @ApiModelProperty("作废成功数量")
    private Integer successAbandonCount;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @ApiModelProperty("作废失败数量")
    private Integer failAbandonCount;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @ApiModelProperty("作废总数")
    private Integer abandonTotal;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @ApiModelProperty("总数")
    private Integer total;
    @ApiModelProperty("释放的蓝字预制发票id集合")
    private List<String> freeBluePreIdList;

}
