package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * BatchBill
 */

@JsonInclude(NON_NULL)
public class BatchBill {

    @ApiModelProperty("流水号")
    private Long serialNo;

    @JsonProperty("batchNo")
    private Long batchNo;
    @JsonProperty("salesbillId")
    private String salesbillId;
    @JsonProperty("importBatchNo")
    private String importBatchNo = null;
    @JsonProperty("salesbillNo")
    private String salesbillNo = null;
    @JsonProperty("sellerNo")
    private String sellerNo = null;
    @JsonProperty("sellerName")
    private String sellerName = null;
    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;
    @JsonProperty("sellerTel")
    private String sellerTel = null;
    @JsonProperty("sellerAddress")
    private String sellerAddress = null;
    @JsonProperty("sellerBankName")
    private String sellerBankName = null;
    @JsonProperty("sellerBankAccount")
    private String sellerBankAccount = null;
    @JsonProperty("sellerTenantId")
    private Long sellerTenantId = null;
    @JsonProperty("sellerGroupId")
    private Long sellerGroupId = null;
    @JsonProperty("sellerId")
    private Long sellerId = null;
    @JsonProperty("purchaserNo")
    private String purchaserNo = null;
    @JsonProperty("purchaserName")
    private String purchaserName = null;
    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo = null;
    @JsonProperty("purchaserTel")
    private String purchaserTel = null;
    @JsonProperty("purchaserAddress")
    private String purchaserAddress = null;
    @JsonProperty("purchaserBankName")
    private String purchaserBankName = null;
    @JsonProperty("purchaserBankAccount")
    private String purchaserBankAccount = null;
    @JsonProperty("purchaserTenantId")
    private Long purchaserTenantId = null;
    @JsonProperty("purchaserGroupId")
    private Long purchaserGroupId = null;
    @JsonProperty("purchaserId")
    private Long purchaserId = null;
    @JsonProperty("systemOrig")
    private String systemOrig = null;
    @JsonProperty("businessBillType")
    private String businessBillType = null;
    @JsonProperty("salesbillType")
    private String salesbillType = null;
    @JsonProperty("invoiceType")
    private String invoiceType = null;
    @JsonProperty("priceMethod")
    private Integer priceMethod = null;
    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;
    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;
    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;
    @JsonProperty("discountWithTax")
    private BigDecimal discountWithTax = null;
    @JsonProperty("discountWithoutTax")
    private BigDecimal discountWithoutTax = null;
    @JsonProperty("discountTax")
    private BigDecimal discountTax = null;
    @JsonProperty("prePayWithoutTax")
    private BigDecimal prePayWithoutTax = null;
    @JsonProperty("prePayTax")
    private BigDecimal prePayTax = null;
    @JsonProperty("prePayWithTax")
    private BigDecimal prePayWithTax = null;
    @JsonProperty("originInvoiceNo")
    private String originInvoiceNo = null;
    @JsonProperty("originInvoiceCode")
    private String originInvoiceCode = null;
    @JsonProperty("redNotification")
    private String redNotification = null;
    @JsonProperty("checkerName")
    private String checkerName = null;
    @JsonProperty("cashierName")
    private String cashierName = null;
    @JsonProperty("invoicerName")
    private String invoicerName = null;
    @JsonProperty("receiveUserEmail")
    private String receiveUserEmail = null;
    @JsonProperty("receiveUserTel")
    private String receiveUserTel = null;
    @JsonProperty("alreadyMakeAmountWithTax")
    private BigDecimal alreadyMakeAmountWithTax = null;
    @JsonProperty("alreadyMakeAmountWithoutTax")
    private BigDecimal alreadyMakeAmountWithoutTax = null;
    @JsonProperty("alreadyMakeAmountTaxAmount")
    private BigDecimal alreadyMakeAmountTaxAmount = null;
    @JsonProperty("sysOrgId")
    private Long sysOrgId = null;
    @JsonProperty("customerNo")
    private String customerNo = null;
    @JsonProperty("status")
    private Integer status = null;

    @ApiModelProperty("备注")
    @JsonProperty("remark")
    private String remark;

    @JsonProperty("ext1")
    private String ext1 = null;
    @JsonProperty("ext2")
    private String ext2 = null;
    @JsonProperty("ext3")
    private String ext3 = null;
    @JsonProperty("ext4")
    private String ext4 = null;
    @JsonProperty("ext5")
    private String ext5 = null;
    @JsonProperty("ext6")
    private String ext6 = null;
    @JsonProperty("ext7")
    private String ext7 = null;
    @JsonProperty("ext8")
    private String ext8 = null;
    @JsonProperty("ext9")
    private String ext9 = null;
    @JsonProperty("ext10")
    private String ext10 = null;
    @JsonProperty("ext11")
    private String ext11 = null;
    @JsonProperty("ext12")
    private String ext12 = null;
    @JsonProperty("ext13")
    private String ext13 = null;
    @JsonProperty("ext14")
    private String ext14 = null;
    @JsonProperty("ext15")
    private String ext15 = null;
    @JsonProperty("ext16")
    private String ext16 = null;
    @JsonProperty("ext17")
    private String ext17 = null;
    @JsonProperty("ext18")
    private String ext18 = null;
    @JsonProperty("ext19")
    private String ext19 = null;
    @JsonProperty("ext20")
    private String ext20 = null;
    @JsonProperty("ext21")
    private String ext21 = null;
    @JsonProperty("ext22")
    private String ext22 = null;
    @JsonProperty("ext23")
    private String ext23 = null;
    @JsonProperty("ext24")
    private String ext24 = null;
    @JsonProperty("ext25")
    private String ext25 = null;
    @JsonProperty("billItems")
    private List<BatchItem> billItems = new ArrayList();

    @JsonProperty("mergeType")
    @ApiModelProperty("合并类型 0-无合并 1-组合 2-自动合并")
    private int mergeType = 0;

    @ApiModelProperty("销方公司id")
    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    @ApiModelProperty("已开含税金额")
    public BigDecimal getAlreadyMakeAmountWithTax() {
        return alreadyMakeAmountWithTax;
    }

    @ApiModelProperty("组织机构id")
    public Long getSysOrgId() {
        return sysOrgId;
    }

    public void setSysOrgId(Long sysOrgId) {
        this.sysOrgId = sysOrgId;
    }

    @ApiModelProperty("用户id")
    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public void setAlreadyMakeAmountWithTax(BigDecimal alreadyMakeAmountWithTax) {
        this.alreadyMakeAmountWithTax = alreadyMakeAmountWithTax;
    }

    @ApiModelProperty("已开不含税金额")
    public BigDecimal getAlreadyMakeAmountWithoutTax() {
        return alreadyMakeAmountWithoutTax;
    }

    public void setAlreadyMakeAmountWithoutTax(BigDecimal alreadyMakeAmountWithoutTax) {
        this.alreadyMakeAmountWithoutTax = alreadyMakeAmountWithoutTax;
    }

    @ApiModelProperty("已开税额")
    public BigDecimal getAlreadyMakeAmountTaxAmount() {
        return alreadyMakeAmountTaxAmount;
    }

    public void setAlreadyMakeAmountTaxAmount(BigDecimal alreadyMakeAmountTaxAmount) {
        this.alreadyMakeAmountTaxAmount = alreadyMakeAmountTaxAmount;
    }

    @JsonIgnore
    public BatchBill batchNo(Long batchNo) {
        this.batchNo = batchNo;
        return this;
    }

    @ApiModelProperty("批次号")
    public Long getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    @JsonIgnore
    public BatchBill importBatchNo(String importBatchNo) {
        this.importBatchNo = importBatchNo;
        return this;
    }

    public String getSalesbillId() {
        return salesbillId;
    }

    public void setSalesbillId(String salesbillId) {
        this.salesbillId = salesbillId;
    }

    @ApiModelProperty("导入批次号")
    public String getImportBatchNo() {
        return importBatchNo;
    }

    public void setImportBatchNo(String importBatchNo) {
        this.importBatchNo = importBatchNo;
    }

    @JsonIgnore
    public BatchBill salesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
        return this;
    }

    @ApiModelProperty("单据号")
    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    @JsonIgnore
    public BatchBill sellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
        return this;
    }

    @ApiModelProperty("销方编号")
    public String getSellerNo() {
        return sellerNo;
    }

    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
    }

    @JsonIgnore
    public BatchBill sellerName(String sellerName) {
        this.sellerName = sellerName;
        return this;
    }

    @ApiModelProperty("销方名称")
    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    @JsonIgnore
    public BatchBill sellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
        return this;
    }

    @ApiModelProperty("销方税号")
    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    @JsonIgnore
    public BatchBill sellerTel(String sellerTel) {
        this.sellerTel = sellerTel;
        return this;
    }

    @ApiModelProperty("销方电话")
    public String getSellerTel() {
        return sellerTel;
    }

    public void setSellerTel(String sellerTel) {
        this.sellerTel = sellerTel;
    }

    @JsonIgnore
    public BatchBill sellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
        return this;
    }

    @ApiModelProperty("销方地址")
    public String getSellerAddress() {
        return sellerAddress;
    }

    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
    }

    @JsonIgnore
    public BatchBill sellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName;
        return this;
    }

    @ApiModelProperty("销方银行名称")
    public String getSellerBankName() {
        return sellerBankName;
    }

    public void setSellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName;
    }

    @JsonIgnore
    public BatchBill sellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
        return this;
    }

    @ApiModelProperty("销方银行账号")
    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    @JsonIgnore
    public BatchBill sellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
        return this;
    }

    @ApiModelProperty("销方租户ID")
    public Long getSellerTenantId() {
        return sellerTenantId;
    }

    public void setSellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    @JsonIgnore
    public BatchBill purchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
        return this;
    }

    @ApiModelProperty("购方编号")
    public String getPurchaserNo() {
        return purchaserNo;
    }

    public void setPurchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
    }

    @JsonIgnore
    public BatchBill purchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
        return this;
    }

    @ApiModelProperty("购方名称")
    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    @JsonIgnore
    public BatchBill purchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
        return this;
    }

    @ApiModelProperty("购方税号")
    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    @JsonIgnore
    public BatchBill purchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
        return this;
    }

    @ApiModelProperty("购方电话")
    public String getPurchaserTel() {
        return purchaserTel;
    }

    public void setPurchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
    }

    @JsonIgnore
    public BatchBill purchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
        return this;
    }

    @ApiModelProperty("购方地址")
    public String getPurchaserAddress() {
        return purchaserAddress;
    }

    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
    }

    @JsonIgnore
    public BatchBill purchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
        return this;
    }

    @ApiModelProperty("购方银行名称")
    public String getPurchaserBankName() {
        return purchaserBankName;
    }

    public void setPurchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
    }

    @JsonIgnore
    public BatchBill purchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
        return this;
    }

    @ApiModelProperty("购方银行账号")
    public String getPurchaserBankAccount() {
        return purchaserBankAccount;
    }

    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
    }

    @JsonIgnore
    public BatchBill purchaserTenantId(Long purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
        return this;
    }

    @ApiModelProperty("购方租户ID")
    public Long getPurchaserTenantId() {
        return purchaserTenantId;
    }

    public void setPurchaserTenantId(Long purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }

    @JsonIgnore
    public BatchBill purchaserId(Long purchaserId) {
        this.purchaserId = purchaserId;
        return this;
    }

    @ApiModelProperty("购方公司ID")
    public Long getPurchaserId() {
        return purchaserId;
    }

    public void setPurchaserId(Long purchaserId) {
        this.purchaserId = purchaserId;
    }

    @JsonIgnore
    public BatchBill systemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
        return this;
    }

    @ApiModelProperty("系统来源")
    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    @JsonIgnore
    public BatchBill businessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
        return this;
    }

    @ApiModelProperty("单据上传方 AR-销方 AP-购方")
    public String getBusinessBillType() {
        return businessBillType;
    }

    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
    }

    @JsonIgnore
    public BatchBill salesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
        return this;
    }

    @ApiModelProperty("业务单据类型")
    public String getSalesbillType() {
        return salesbillType;
    }

    public void setSalesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
    }

    @JsonIgnore
    public BatchBill invoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    @ApiModelProperty("发票类型")
    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    @JsonIgnore
    public BatchBill priceMethod(Integer priceMethod) {
        this.priceMethod = priceMethod;
        return this;
    }

    @ApiModelProperty("计价方式")
    public Integer getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(Integer priceMethod) {
        this.priceMethod = priceMethod;
    }

    @JsonIgnore
    public BatchBill amountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
        return this;
    }

    @ApiModelProperty("含税金额")
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @JsonIgnore
    public BatchBill amountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    @ApiModelProperty("不含税金额")
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public BatchBill taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty("税额")
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    @JsonIgnore
    public BatchBill discountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
        return this;
    }

    @ApiModelProperty("含税折扣")
    public BigDecimal getDiscountWithTax() {
        return discountWithTax;
    }

    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    @JsonIgnore
    public BatchBill discountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
        return this;
    }

    @ApiModelProperty("不含税折扣")
    public BigDecimal getDiscountWithoutTax() {
        return discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    @JsonIgnore
    public BatchBill discountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
        return this;
    }

    @ApiModelProperty("折扣税额")
    public BigDecimal getDiscountTax() {
        return discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    @JsonIgnore
    public BatchBill prePayWithoutTax(BigDecimal prePayWithoutTax) {
        this.prePayWithoutTax = prePayWithoutTax;
        return this;
    }

    @ApiModelProperty("预付不含税金额")
    public BigDecimal getPrePayWithoutTax() {
        return prePayWithoutTax;
    }

    public void setPrePayWithoutTax(BigDecimal prePayWithoutTax) {
        this.prePayWithoutTax = prePayWithoutTax;
    }

    @JsonIgnore
    public BatchBill prePayTax(BigDecimal prePayTax) {
        this.prePayTax = prePayTax;
        return this;
    }

    @ApiModelProperty("预付税额")
    public BigDecimal getPrePayTax() {
        return prePayTax;
    }

    public void setPrePayTax(BigDecimal prePayTax) {
        this.prePayTax = prePayTax;
    }

    @JsonIgnore
    public BatchBill prePayWithTax(BigDecimal prePayWithTax) {
        this.prePayWithTax = prePayWithTax;
        return this;
    }

    @ApiModelProperty("预付含税金额")
    public BigDecimal getPrePayWithTax() {
        return prePayWithTax;
    }

    public void setPrePayWithTax(BigDecimal prePayWithTax) {
        this.prePayWithTax = prePayWithTax;
    }

    @JsonIgnore
    public BatchBill originInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo;
        return this;
    }

    @ApiModelProperty("原发票号码")
    public String getOriginInvoiceNo() {
        return originInvoiceNo;
    }

    public void setOriginInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo;
    }

    @JsonIgnore
    public BatchBill originInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode;
        return this;
    }

    @ApiModelProperty("原发票代码")
    public String getOriginInvoiceCode() {
        return originInvoiceCode;
    }

    public void setOriginInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode;
    }

    @JsonIgnore
    public BatchBill redNotification(String redNotification) {
        this.redNotification = redNotification;
        return this;
    }

    @ApiModelProperty("红字信息编号")
    public String getRedNotification() {
        return redNotification;
    }

    public void setRedNotification(String redNotification) {
        this.redNotification = redNotification;
    }

    @JsonIgnore
    public BatchBill checkerName(String checkerName) {
        this.checkerName = checkerName;
        return this;
    }

    @ApiModelProperty("复核人")
    public String getCheckerName() {
        return checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }

    @JsonIgnore
    public BatchBill cashierName(String cashierName) {
        this.cashierName = cashierName;
        return this;
    }

    @ApiModelProperty("收款人")
    public String getCashierName() {
        return cashierName;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    @JsonIgnore
    public BatchBill invoicerName(String invoicerName) {
        this.invoicerName = invoicerName;
        return this;
    }

    @ApiModelProperty("开票人")
    public String getInvoicerName() {
        return invoicerName;
    }

    public void setInvoicerName(String invoicerName) {
        this.invoicerName = invoicerName;
    }

    @JsonIgnore
    public BatchBill receiveUserEmail(String receiveUserEmail) {
        this.receiveUserEmail = receiveUserEmail;
        return this;
    }

    @ApiModelProperty("接收方邮箱")
    public String getReceiveUserEmail() {
        return receiveUserEmail;
    }

    public void setReceiveUserEmail(String receiveUserEmail) {
        this.receiveUserEmail = receiveUserEmail;
    }

    @JsonIgnore
    public BatchBill receiveUserTel(String receiveUserTel) {
        this.receiveUserTel = receiveUserTel;
        return this;
    }

    @ApiModelProperty("接收方电话")
    public String getReceiveUserTel() {
        return receiveUserTel;
    }

    public void setReceiveUserTel(String receiveUserTel) {
        this.receiveUserTel = receiveUserTel;
    }

    @JsonIgnore
    public BatchBill status(Integer status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty("状态")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @JsonIgnore
    public BatchBill ext1(String ext1) {
        this.ext1 = ext1;
        return this;
    }

    @ApiModelProperty("扩展字段1")
    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    @JsonIgnore
    public BatchBill ext2(String ext2) {
        this.ext2 = ext2;
        return this;
    }

    @ApiModelProperty("扩展字段2")
    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    @JsonIgnore
    public BatchBill ext3(String ext3) {
        this.ext3 = ext3;
        return this;
    }

    @ApiModelProperty("扩展字段3")
    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    @JsonIgnore
    public BatchBill ext4(String ext4) {
        this.ext4 = ext4;
        return this;
    }

    @ApiModelProperty("扩展字段4")
    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    @JsonIgnore
    public BatchBill ext5(String ext5) {
        this.ext5 = ext5;
        return this;
    }

    @ApiModelProperty("扩展字段5")
    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    @JsonIgnore
    public BatchBill ext6(String ext6) {
        this.ext6 = ext6;
        return this;
    }

    @ApiModelProperty("扩展字段6")
    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    @JsonIgnore
    public BatchBill ext7(String ext7) {
        this.ext7 = ext7;
        return this;
    }

    @ApiModelProperty("扩展字段7")
    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    @JsonIgnore
    public BatchBill ext8(String ext8) {
        this.ext8 = ext8;
        return this;
    }

    @ApiModelProperty("扩展字段8")
    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    @JsonIgnore
    public BatchBill ext9(String ext9) {
        this.ext9 = ext9;
        return this;
    }

    @ApiModelProperty("扩展字段9")
    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    @JsonIgnore
    public BatchBill ext10(String ext10) {
        this.ext10 = ext10;
        return this;
    }

    @ApiModelProperty("扩展字段10")
    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    @JsonIgnore
    public BatchBill ext11(String ext11) {
        this.ext11 = ext11;
        return this;
    }

    @ApiModelProperty("扩展字段11")
    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    @JsonIgnore
    public BatchBill ext12(String ext12) {
        this.ext12 = ext12;
        return this;
    }

    @ApiModelProperty("扩展字段12")
    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    @JsonIgnore
    public BatchBill ext13(String ext13) {
        this.ext13 = ext13;
        return this;
    }

    @ApiModelProperty("扩展字段13")
    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    @JsonIgnore
    public BatchBill ext14(String ext14) {
        this.ext14 = ext14;
        return this;
    }

    @ApiModelProperty("扩展字段14")
    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    @JsonIgnore
    public BatchBill ext15(String ext15) {
        this.ext15 = ext15;
        return this;
    }

    @ApiModelProperty("扩展字段15")
    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    @JsonIgnore
    public BatchBill ext16(String ext16) {
        this.ext16 = ext16;
        return this;
    }

    @ApiModelProperty("扩展字段16")
    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    @JsonIgnore
    public BatchBill ext17(String ext17) {
        this.ext17 = ext17;
        return this;
    }

    @ApiModelProperty("扩展字段17")
    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    @JsonIgnore
    public BatchBill ext18(String ext18) {
        this.ext18 = ext18;
        return this;
    }

    @ApiModelProperty("扩展字段18")
    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    @JsonIgnore
    public BatchBill ext19(String ext19) {
        this.ext19 = ext19;
        return this;
    }

    @ApiModelProperty("扩展字段19")
    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    @JsonIgnore
    public BatchBill ext20(String ext20) {
        this.ext20 = ext20;
        return this;
    }

    @ApiModelProperty("扩展字段20")
    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    @JsonIgnore
    public BatchBill ext21(String ext21) {
        this.ext21 = ext21;
        return this;
    }

    @ApiModelProperty("扩展字段21")
    public String getExt21() {
        return ext21;
    }

    public void setExt21(String ext21) {
        this.ext21 = ext21;
    }

    @JsonIgnore
    public BatchBill ext22(String ext22) {
        this.ext22 = ext22;
        return this;
    }

    @ApiModelProperty("扩展字段22")
    public String getExt22() {
        return ext22;
    }

    public void setExt22(String ext22) {
        this.ext22 = ext22;
    }

    @JsonIgnore
    public BatchBill ext23(String ext23) {
        this.ext23 = ext23;
        return this;
    }

    @ApiModelProperty("扩展字段23")
    public String getExt23() {
        return ext23;
    }

    public void setExt23(String ext23) {
        this.ext23 = ext23;
    }

    @JsonIgnore
    public BatchBill ext24(String ext24) {
        this.ext24 = ext24;
        return this;
    }

    @ApiModelProperty("扩展字段24")
    public String getExt24() {
        return ext24;
    }

    public void setExt24(String ext24) {
        this.ext24 = ext24;
    }

    @JsonIgnore
    public BatchBill ext25(String ext25) {
        this.ext25 = ext25;
        return this;
    }

    @ApiModelProperty("扩展字段25")
    public String getExt25() {
        return ext25;
    }

    public void setExt25(String ext25) {
        this.ext25 = ext25;
    }

    @JsonIgnore
    public BatchBill billItems(List<BatchItem> billItems) {
        this.billItems = billItems;
        return this;
    }

    public int getMergeType() {
        return mergeType;
    }

    public void setMergeType(int mergeType) {
        this.mergeType = mergeType;
    }

    public List<BatchItem> getBillItems() {
        return billItems;
    }

    public void setBillItems(List<BatchItem> billItems) {
        this.billItems = billItems;
    }

    public Long getSellerGroupId() {
        return sellerGroupId;
    }

    public void setSellerGroupId(Long sellerGroupId) {
        this.sellerGroupId = sellerGroupId;
    }

    public Long getPurchaserGroupId() {
        return purchaserGroupId;
    }

    public void setPurchaserGroupId(Long purchaserGroupId) {
        this.purchaserGroupId = purchaserGroupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if ((o == null) || (getClass() != o.getClass())) {
            return false;
        }
        BatchBill billUploadMain = (BatchBill) o;
        return (Objects.equals(batchNo, batchNo)) && (Objects.equals(importBatchNo, importBatchNo))
                && (Objects.equals(salesbillNo, salesbillNo)) && (Objects.equals(sellerNo, sellerNo))
                && (Objects.equals(sellerName, sellerName)) && (Objects.equals(sellerTaxNo, sellerTaxNo))
                && (Objects.equals(sellerTel, sellerTel)) && (Objects.equals(sellerAddress, sellerAddress))
                && (Objects.equals(sellerBankName, sellerBankName))
                && (Objects.equals(sellerBankAccount, sellerBankAccount))
                && (Objects.equals(sellerTenantId, sellerTenantId)) && (Objects.equals(purchaserNo, purchaserNo))
                && (Objects.equals(purchaserName, purchaserName)) && (Objects.equals(purchaserTaxNo, purchaserTaxNo))
                && (Objects.equals(purchaserTel, purchaserTel)) && (Objects.equals(purchaserAddress, purchaserAddress))
                && (Objects.equals(purchaserBankName, purchaserBankName))
                && (Objects.equals(purchaserBankAccount, purchaserBankAccount))
                && (Objects.equals(purchaserTenantId, purchaserTenantId)) && (Objects.equals(purchaserId, purchaserId))
                && (Objects.equals(systemOrig, systemOrig)) && (Objects.equals(businessBillType, businessBillType))
                && (Objects.equals(salesbillType, salesbillType)) && (Objects.equals(invoiceType, invoiceType))
                && (Objects.equals(priceMethod, priceMethod)) && (Objects.equals(amountWithTax, amountWithTax))
                && (Objects.equals(amountWithoutTax, amountWithoutTax)) && (Objects.equals(taxAmount, taxAmount))
                && (Objects.equals(discountWithTax, discountWithTax))
                && (Objects.equals(discountWithoutTax, discountWithoutTax))
                && (Objects.equals(discountTax, discountTax)) && (Objects.equals(prePayWithoutTax, prePayWithoutTax))
                && (Objects.equals(prePayTax, prePayTax)) && (Objects.equals(prePayWithTax, prePayWithTax))
                && (Objects.equals(originInvoiceNo, originInvoiceNo))
                && (Objects.equals(originInvoiceCode, originInvoiceCode))
                && (Objects.equals(redNotification, redNotification)) && (Objects.equals(checkerName, checkerName))
                && (Objects.equals(cashierName, cashierName)) && (Objects.equals(invoicerName, invoicerName))
                && (Objects.equals(receiveUserEmail, receiveUserEmail))
                && (Objects.equals(receiveUserTel, receiveUserTel)) && (Objects.equals(status, status))
                && (Objects.equals(ext1, ext1)) && (Objects.equals(ext2, ext2)) && (Objects.equals(ext3, ext3))
                && (Objects.equals(ext4, ext4)) && (Objects.equals(ext5, ext5)) && (Objects.equals(ext6, ext6))
                && (Objects.equals(ext7, ext7)) && (Objects.equals(ext8, ext8)) && (Objects.equals(ext9, ext9))
                && (Objects.equals(ext10, ext10)) && (Objects.equals(ext11, ext11)) && (Objects.equals(ext12, ext12))
                && (Objects.equals(ext13, ext13)) && (Objects.equals(ext14, ext14)) && (Objects.equals(ext15, ext15))
                && (Objects.equals(ext16, ext16)) && (Objects.equals(ext17, ext17)) && (Objects.equals(ext18, ext18))
                && (Objects.equals(ext19, ext19)) && (Objects.equals(ext20, ext20)) && (Objects.equals(ext21, ext21))
                && (Objects.equals(ext22, ext22)) && (Objects.equals(ext23, ext23)) && (Objects.equals(ext24, ext24))
                && (Objects.equals(ext25, ext25)) && (Objects.equals(billItems, billItems));
    }

    public int hashCode() {
        return Objects.hash(new Object[] { batchNo, importBatchNo, salesbillNo, sellerNo, sellerName, sellerTaxNo,
                sellerTel, sellerAddress, sellerBankName, sellerBankAccount, sellerTenantId, purchaserNo, purchaserName,
                purchaserTaxNo, purchaserTel, purchaserAddress, purchaserBankName, purchaserBankAccount,
                purchaserTenantId, purchaserId, systemOrig, businessBillType, salesbillType, invoiceType, priceMethod,
                amountWithTax, amountWithoutTax, taxAmount, discountWithTax, discountWithoutTax, discountTax,
                prePayWithoutTax, prePayTax, prePayWithTax, originInvoiceNo, originInvoiceCode, redNotification,
                checkerName, cashierName, invoicerName, receiveUserEmail, receiveUserTel, status, ext1, ext2, ext3,
                ext4, ext5, ext6, ext7, ext8, ext9, ext10, ext11, ext12, ext13, ext14, ext15, ext16, ext17, ext18,
                ext19, ext20, ext21, ext22, ext23, ext24, ext25, billItems });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchBill {\n");

        sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
        sb.append("    importBatchNo: ").append(toIndentedString(importBatchNo)).append("\n");
        sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
        sb.append("    sellerNo: ").append(toIndentedString(sellerNo)).append("\n");
        sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
        sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
        sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
        sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
        sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
        sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
        sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
        sb.append("    purchaserNo: ").append(toIndentedString(purchaserNo)).append("\n");
        sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
        sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
        sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
        sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
        sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
        sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
        sb.append("    purchaserTenantId: ").append(toIndentedString(purchaserTenantId)).append("\n");
        sb.append("    purchaserId: ").append(toIndentedString(purchaserId)).append("\n");
        sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
        sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
        sb.append("    salesbillType: ").append(toIndentedString(salesbillType)).append("\n");
        sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
        sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
        sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
        sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
        sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
        sb.append("    discountWithTax: ").append(toIndentedString(discountWithTax)).append("\n");
        sb.append("    discountWithoutTax: ").append(toIndentedString(discountWithoutTax)).append("\n");
        sb.append("    discountTax: ").append(toIndentedString(discountTax)).append("\n");
        sb.append("    prePayWithoutTax: ").append(toIndentedString(prePayWithoutTax)).append("\n");
        sb.append("    prePayTax: ").append(toIndentedString(prePayTax)).append("\n");
        sb.append("    prePayWithTax: ").append(toIndentedString(prePayWithTax)).append("\n");
        sb.append("    originInvoiceNo: ").append(toIndentedString(originInvoiceNo)).append("\n");
        sb.append("    originInvoiceCode: ").append(toIndentedString(originInvoiceCode)).append("\n");
        sb.append("    redNotification: ").append(toIndentedString(redNotification)).append("\n");
        sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
        sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
        sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
        sb.append("    receiveUserEmail: ").append(toIndentedString(receiveUserEmail)).append("\n");
        sb.append("    receiveUserTel: ").append(toIndentedString(receiveUserTel)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    ext1: ").append(toIndentedString(ext1)).append("\n");
        sb.append("    ext2: ").append(toIndentedString(ext2)).append("\n");
        sb.append("    ext3: ").append(toIndentedString(ext3)).append("\n");
        sb.append("    ext4: ").append(toIndentedString(ext4)).append("\n");
        sb.append("    ext5: ").append(toIndentedString(ext5)).append("\n");
        sb.append("    ext6: ").append(toIndentedString(ext6)).append("\n");
        sb.append("    ext7: ").append(toIndentedString(ext7)).append("\n");
        sb.append("    ext8: ").append(toIndentedString(ext8)).append("\n");
        sb.append("    ext9: ").append(toIndentedString(ext9)).append("\n");
        sb.append("    ext10: ").append(toIndentedString(ext10)).append("\n");
        sb.append("    ext11: ").append(toIndentedString(ext11)).append("\n");
        sb.append("    ext12: ").append(toIndentedString(ext12)).append("\n");
        sb.append("    ext13: ").append(toIndentedString(ext13)).append("\n");
        sb.append("    ext14: ").append(toIndentedString(ext14)).append("\n");
        sb.append("    ext15: ").append(toIndentedString(ext15)).append("\n");
        sb.append("    ext16: ").append(toIndentedString(ext16)).append("\n");
        sb.append("    ext17: ").append(toIndentedString(ext17)).append("\n");
        sb.append("    ext18: ").append(toIndentedString(ext18)).append("\n");
        sb.append("    ext19: ").append(toIndentedString(ext19)).append("\n");
        sb.append("    ext20: ").append(toIndentedString(ext20)).append("\n");
        sb.append("    ext21: ").append(toIndentedString(ext21)).append("\n");
        sb.append("    ext22: ").append(toIndentedString(ext22)).append("\n");
        sb.append("    ext23: ").append(toIndentedString(ext23)).append("\n");
        sb.append("    ext24: ").append(toIndentedString(ext24)).append("\n");
        sb.append("    ext25: ").append(toIndentedString(ext25)).append("\n");
        sb.append("    batchItems: ").append(toIndentedString(billItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Long getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(Long serialNo) {
        this.serialNo = serialNo;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
