package com.xforceplus.seller.invoice.client.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * BatchItem
 */

@JsonInclude(NON_NULL)
public class BatchItem {

    @JsonProperty("salesbillItemId")
    private Long salesbillItemId = null;
    @JsonProperty("salesbillId")
    private Long salesbillId = null;
    @JsonProperty("salesbillNo")
    private String salesbillNo;
    @JsonProperty("salesbillItemNo")
    private String salesbillItemNo = null;
    @JsonProperty("itemCode")
    private String itemCode = null;
    @JsonProperty("itemName")
    private String itemName = null;
    @JsonProperty("itemShortName")
    private String itemShortName = null;
    @JsonProperty("itemSpec")
    private String itemSpec = null;
    @JsonProperty("unitPriceWithTax")
    private BigDecimal unitPriceWithTax = null;
    @JsonProperty("unitPrice")
    private BigDecimal unitPrice = null;
    @JsonProperty("outterDiscountWithTax")
    private BigDecimal outterDiscountWithTax = null;
    @JsonProperty("outterDiscountWithoutTax")
    private BigDecimal outterDiscountWithoutTax = null;
    @JsonProperty("outterDiscountTax")
    private BigDecimal outterDiscountTax = null;
    @JsonProperty("innerDiscountWithTax")
    private BigDecimal innerDiscountWithTax = null;
    @JsonProperty("innerDiscountWithoutTax")
    private BigDecimal innerDiscountWithoutTax = null;
    @JsonProperty("innerDiscountTax")
    private BigDecimal innerDiscountTax = null;
    @JsonProperty("prepayAmountWithTax")
    private BigDecimal prepayAmountWithTax = null;
    @JsonProperty("prepayAmountWithoutTax")
    private BigDecimal prepayAmountWithoutTax = null;
    @JsonProperty("prepayAmountTax")
    private BigDecimal prepayAmountTax = null;
    @JsonProperty("quantity")
    private BigDecimal quantity = null;
    @JsonProperty("quantityUnit")
    private String quantityUnit = null;
    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;
    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;
    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;
    @JsonProperty("taxRate")
    private BigDecimal taxRate = null;
    @JsonProperty("taxPre")
    private String taxPre = null;
    @JsonProperty("taxPreCon")
    private String taxPreCon = null;
    @JsonProperty("zeroTax")
    private String zeroTax = null;
    @JsonProperty("goodsTaxNo")
    private String goodsTaxNo = null;
    @JsonProperty("taxConvertCode")
    private String taxConvertCode = null;
    @JsonProperty("largeCategoryName")
    private String largeCategoryName = null;
    @JsonProperty("medianCategoryName")
    private String medianCategoryName = null;
    @JsonProperty("smallCategoryName")
    private String smallCategoryName = null;
    @JsonProperty("splitCode")
    private String splitCode;
    @JsonProperty("itemTypeCode")
    private String itemTypeCode;
    @JsonProperty("remark")
    private String remark;
    @JsonProperty("leftQuantity")
    private BigDecimal leftQuantity;
    @JsonProperty("leftAmountWithoutTax")
    private BigDecimal leftAmountWithoutTax;
    @JsonProperty("leftTaxAmount")
    private BigDecimal leftTaxAmount;
    @JsonProperty("leftAmountWithTax")
    private BigDecimal leftAmountWithTax;
    @JsonProperty("leftDiscountWithoutTax")
    private BigDecimal leftDiscountWithoutTax;
    @JsonProperty("leftDiscountTax")
    private BigDecimal leftDiscountTax;
    @JsonProperty("leftDiscountWithTax")
    private BigDecimal leftDiscountWithTax;
    @JsonProperty("leftTaxDeduction")
    private BigDecimal leftTaxDeduction;
    @JsonProperty("deduction")
    private BigDecimal deduction;
    private BigDecimal alreadyMakeQuantity = BigDecimal.ZERO;
    private BigDecimal alreadyMakeAmountWithoutTax = BigDecimal.ZERO;
    private BigDecimal alreadyMakeTaxAmount = BigDecimal.ZERO;
    private BigDecimal alreadyMakeAmountWithTax = BigDecimal.ZERO;
    private BigDecimal alreadyMakeDiscountWithoutTax = BigDecimal.ZERO;
    private BigDecimal alreadyMakeDiscountTax = BigDecimal.ZERO;
    private BigDecimal alreadyMakeDiscountWithTax = BigDecimal.ZERO;
    private BigDecimal alreadyMakeTaxDeduction = BigDecimal.ZERO;
    private BigDecimal alreadyOutterDiscountWithTax = BigDecimal.ZERO; // 价外折扣含税
    private BigDecimal alreadyOutterDiscountWithoutTax = BigDecimal.ZERO; // 价外折扣不含税
    private BigDecimal alreadyOutterDiscountTax = BigDecimal.ZERO; // 价外折扣税额
    private BigDecimal alreadyInnerDiscountWithTax = BigDecimal.ZERO; // 价内折扣含税
    private BigDecimal alreadyInnerDiscountWithoutTax = BigDecimal.ZERO; // 价内折扣不含税
    private BigDecimal alreadyInnerDiscountTax = BigDecimal.ZERO; // 价内折扣税额
    private BigDecimal alreadyOutterPrepayAmountWithTax = BigDecimal.ZERO; // 价外预付卡含税
    private BigDecimal alreadyOutterPrepayAmountWithoutTax = BigDecimal.ZERO; // 价外预付卡不含税
    private BigDecimal alreadyOutterPrepayAmountTax = BigDecimal.ZERO; // 价外预付卡税额
    private BigDecimal alreadyInnerPrepayAmountWithTax = BigDecimal.ZERO; // 价内预付卡含税
    private BigDecimal alreadyInnerPrepayAmountWithoutTax = BigDecimal.ZERO; // 价内预付卡不含税
    private BigDecimal alreadyInnerPrepayAmountTax = BigDecimal.ZERO; // 价内预付卡税额
    private BigDecimal leftOutterDiscountWithTax; // 价外折扣含税
    private BigDecimal leftOutterDiscountWithoutTax; // 价外折扣不含税
    private BigDecimal leftOutterDiscountTax; // 价外折扣税额
    private BigDecimal leftInnerDiscountWithTax; // 价内折扣含税
    private BigDecimal leftInnerDiscountWithoutTax; // 价内折扣不含税
    private BigDecimal leftInnerDiscountTax; // 价内折扣税额
    private BigDecimal leftOutterPrepayAmountWithTax; // 价外预付卡含税
    private BigDecimal leftOutterPrepayAmountWithoutTax; // 价外预付卡不含税
    private BigDecimal leftOutterPrepayAmountTax; // 价外预付卡税额
    private BigDecimal leftInnerPrepayAmountWithTax; // 价内预付卡含税
    private BigDecimal leftInnerPrepayAmountWithoutTax; // 价内预付卡不含税
    private BigDecimal leftInnerPrepayAmountTax; // 价内预付卡税额
    private BigDecimal discountWithoutTax;
    private BigDecimal discountTax;
    private BigDecimal discountWithTax;
    private BigDecimal innerPrepayAmountWithTax;
    private BigDecimal innerPrepayAmountWithoutTax;
    private BigDecimal innerPrepayAmountTax;
    private BigDecimal outterPrepayAmountWithTax;
    private BigDecimal outterPrepayAmountWithoutTax;
    private BigDecimal outterPrepayAmountTax;
    @JsonProperty("ext1")
    private String ext1 = null;
    @JsonProperty("ext2")
    private String ext2 = null;
    @JsonProperty("ext3")
    private String ext3 = null;
    @JsonProperty("ext4")
    private String ext4 = null;
    @JsonProperty("ext5")
    private String ext5 = null;
    @JsonProperty("ext6")
    private String ext6 = null;
    @JsonProperty("ext7")
    private String ext7 = null;
    @JsonProperty("ext8")
    private String ext8 = null;
    @JsonProperty("ext9")
    private String ext9 = null;
    @JsonProperty("ext10")
    private String ext10 = null;
    @JsonProperty("ext11")
    private String ext11 = null;
    @JsonProperty("ext12")
    private String ext12 = null;
    @JsonProperty("ext13")
    private String ext13 = null;
    @JsonProperty("ext14")
    private String ext14 = null;
    @JsonProperty("ext15")
    private String ext15 = null;
    @JsonProperty("ext16")
    private String ext16 = null;
    @JsonProperty("ext17")
    private String ext17 = null;
    @JsonProperty("ext18")
    private String ext18 = null;
    @JsonProperty("ext19")
    private String ext19 = null;
    @JsonProperty("ext20")
    private String ext20 = null;
    @JsonProperty("goodsNoVer")
    @ApiModelProperty("编码版本号")
    private String goodsNoVer;

    /**
     * 结算单有单价数量
     */
    private boolean hasUnitPriceAndQuantity;

    public boolean isHasUnitPriceAndQuantity() {
        return hasUnitPriceAndQuantity;
    }

    public void setHasUnitPriceAndQuantity(boolean hasUnitPriceAndQuantity) {
        this.hasUnitPriceAndQuantity = hasUnitPriceAndQuantity;
    }

    public String getGoodsNoVer() {
        return goodsNoVer;
    }

    public void setGoodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer;
    }

    public BigDecimal getAlreadyMakeTaxDeduction() {
        return alreadyMakeTaxDeduction;
    }

    public void setAlreadyMakeTaxDeduction(BigDecimal alreadyMakeTaxDeduction) {
        this.alreadyMakeTaxDeduction = alreadyMakeTaxDeduction;
    }

    public BigDecimal getDiscountWithoutTax() {
        return discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    public BigDecimal getDiscountTax() {
        return discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    public BigDecimal getDiscountWithTax() {
        return discountWithTax;
    }

    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    public BigDecimal getAlreadyMakeQuantity() {
        return alreadyMakeQuantity;
    }

    public BigDecimal getAlreadyOutterDiscountWithTax() {
        return alreadyOutterDiscountWithTax;
    }

    public void setAlreadyOutterDiscountWithTax(BigDecimal alreadyOutterDiscountWithTax) {
        this.alreadyOutterDiscountWithTax = alreadyOutterDiscountWithTax;
    }

    public BigDecimal getAlreadyOutterDiscountWithoutTax() {
        return alreadyOutterDiscountWithoutTax;
    }

    public void setAlreadyOutterDiscountWithoutTax(BigDecimal alreadyOutterDiscountWithoutTax) {
        this.alreadyOutterDiscountWithoutTax = alreadyOutterDiscountWithoutTax;
    }

    public BigDecimal getAlreadyOutterDiscountTax() {
        return alreadyOutterDiscountTax;
    }

    public void setAlreadyOutterDiscountTax(BigDecimal alreadyOutterDiscountTax) {
        this.alreadyOutterDiscountTax = alreadyOutterDiscountTax;
    }

    public BigDecimal getAlreadyInnerDiscountWithTax() {
        return alreadyInnerDiscountWithTax;
    }

    public void setAlreadyInnerDiscountWithTax(BigDecimal alreadyInnerDiscountWithTax) {
        this.alreadyInnerDiscountWithTax = alreadyInnerDiscountWithTax;
    }

    public BigDecimal getAlreadyInnerDiscountWithoutTax() {
        return alreadyInnerDiscountWithoutTax;
    }

    public void setAlreadyInnerDiscountWithoutTax(BigDecimal alreadyInnerDiscountWithoutTax) {
        this.alreadyInnerDiscountWithoutTax = alreadyInnerDiscountWithoutTax;
    }

    public BigDecimal getAlreadyInnerDiscountTax() {
        return alreadyInnerDiscountTax;
    }

    public void setAlreadyInnerDiscountTax(BigDecimal alreadyInnerDiscountTax) {
        this.alreadyInnerDiscountTax = alreadyInnerDiscountTax;
    }

    public BigDecimal getAlreadyOutterPrepayAmountWithTax() {
        return alreadyOutterPrepayAmountWithTax;
    }

    public void setAlreadyOutterPrepayAmountWithTax(BigDecimal alreadyOutterPrepayAmountWithTax) {
        this.alreadyOutterPrepayAmountWithTax = alreadyOutterPrepayAmountWithTax;
    }

    public BigDecimal getAlreadyOutterPrepayAmountWithoutTax() {
        return alreadyOutterPrepayAmountWithoutTax;
    }

    public void setAlreadyOutterPrepayAmountWithoutTax(BigDecimal alreadyOutterPrepayAmountWithoutTax) {
        this.alreadyOutterPrepayAmountWithoutTax = alreadyOutterPrepayAmountWithoutTax;
    }

    public BigDecimal getAlreadyOutterPrepayAmountTax() {
        return alreadyOutterPrepayAmountTax;
    }

    public void setAlreadyOutterPrepayAmountTax(BigDecimal alreadyOutterPrepayAmountTax) {
        this.alreadyOutterPrepayAmountTax = alreadyOutterPrepayAmountTax;
    }

    public BigDecimal getAlreadyInnerPrepayAmountWithTax() {
        return alreadyInnerPrepayAmountWithTax;
    }

    public void setAlreadyInnerPrepayAmountWithTax(BigDecimal alreadyInnerPrepayAmountWithTax) {
        this.alreadyInnerPrepayAmountWithTax = alreadyInnerPrepayAmountWithTax;
    }

    public BigDecimal getAlreadyInnerPrepayAmountWithoutTax() {
        return alreadyInnerPrepayAmountWithoutTax;
    }

    public void setAlreadyInnerPrepayAmountWithoutTax(BigDecimal alreadyInnerPrepayAmountWithoutTax) {
        this.alreadyInnerPrepayAmountWithoutTax = alreadyInnerPrepayAmountWithoutTax;
    }

    public BigDecimal getAlreadyInnerPrepayAmountTax() {
        return alreadyInnerPrepayAmountTax;
    }

    public void setAlreadyInnerPrepayAmountTax(BigDecimal alreadyInnerPrepayAmountTax) {
        this.alreadyInnerPrepayAmountTax = alreadyInnerPrepayAmountTax;
    }

    public BigDecimal getLeftOutterDiscountWithTax() {
        return leftOutterDiscountWithTax;
    }

    public void setLeftOutterDiscountWithTax(BigDecimal leftOutterDiscountWithTax) {
        this.leftOutterDiscountWithTax = leftOutterDiscountWithTax;
    }

    public BigDecimal getLeftOutterDiscountWithoutTax() {
        return leftOutterDiscountWithoutTax;
    }

    public void setLeftOutterDiscountWithoutTax(BigDecimal leftOutterDiscountWithoutTax) {
        this.leftOutterDiscountWithoutTax = leftOutterDiscountWithoutTax;
    }

    public BigDecimal getLeftOutterDiscountTax() {
        return leftOutterDiscountTax;
    }

    public void setLeftOutterDiscountTax(BigDecimal leftOutterDiscountTax) {
        this.leftOutterDiscountTax = leftOutterDiscountTax;
    }

    public BigDecimal getLeftInnerDiscountWithTax() {
        return leftInnerDiscountWithTax;
    }

    public void setLeftInnerDiscountWithTax(BigDecimal leftInnerDiscountWithTax) {
        this.leftInnerDiscountWithTax = leftInnerDiscountWithTax;
    }

    public BigDecimal getLeftInnerDiscountWithoutTax() {
        return leftInnerDiscountWithoutTax;
    }

    public void setLeftInnerDiscountWithoutTax(BigDecimal leftInnerDiscountWithoutTax) {
        this.leftInnerDiscountWithoutTax = leftInnerDiscountWithoutTax;
    }

    public BigDecimal getLeftInnerDiscountTax() {
        return leftInnerDiscountTax;
    }

    public void setLeftInnerDiscountTax(BigDecimal leftInnerDiscountTax) {
        this.leftInnerDiscountTax = leftInnerDiscountTax;
    }

    public BigDecimal getLeftOutterPrepayAmountWithTax() {
        return leftOutterPrepayAmountWithTax;
    }

    public void setLeftOutterPrepayAmountWithTax(BigDecimal leftOutterPrepayAmountWithTax) {
        this.leftOutterPrepayAmountWithTax = leftOutterPrepayAmountWithTax;
    }

    public BigDecimal getLeftOutterPrepayAmountWithoutTax() {
        return leftOutterPrepayAmountWithoutTax;
    }

    public void setLeftOutterPrepayAmountWithoutTax(BigDecimal leftOutterPrepayAmountWithoutTax) {
        this.leftOutterPrepayAmountWithoutTax = leftOutterPrepayAmountWithoutTax;
    }

    public BigDecimal getLeftOutterPrepayAmountTax() {
        return leftOutterPrepayAmountTax;
    }

    public void setLeftOutterPrepayAmountTax(BigDecimal leftOutterPrepayAmountTax) {
        this.leftOutterPrepayAmountTax = leftOutterPrepayAmountTax;
    }

    public BigDecimal getLeftInnerPrepayAmountWithTax() {
        return leftInnerPrepayAmountWithTax;
    }

    public void setLeftInnerPrepayAmountWithTax(BigDecimal leftInnerPrepayAmountWithTax) {
        this.leftInnerPrepayAmountWithTax = leftInnerPrepayAmountWithTax;
    }

    public BigDecimal getLeftInnerPrepayAmountWithoutTax() {
        return leftInnerPrepayAmountWithoutTax;
    }

    public void setLeftInnerPrepayAmountWithoutTax(BigDecimal leftInnerPrepayAmountWithoutTax) {
        this.leftInnerPrepayAmountWithoutTax = leftInnerPrepayAmountWithoutTax;
    }

    public BigDecimal getLeftInnerPrepayAmountTax() {
        return leftInnerPrepayAmountTax;
    }

    public void setLeftInnerPrepayAmountTax(BigDecimal leftInnerPrepayAmountTax) {
        this.leftInnerPrepayAmountTax = leftInnerPrepayAmountTax;
    }

    public void setAlreadyMakeQuantity(BigDecimal alreadyMakeQuantity) {
        this.alreadyMakeQuantity = alreadyMakeQuantity;
    }

    public BigDecimal getAlreadyMakeAmountWithoutTax() {
        return alreadyMakeAmountWithoutTax;
    }

    public void setAlreadyMakeAmountWithoutTax(BigDecimal alreadyMakeAmountWithoutTax) {
        this.alreadyMakeAmountWithoutTax = alreadyMakeAmountWithoutTax;
    }

    public BigDecimal getAlreadyMakeTaxAmount() {
        return alreadyMakeTaxAmount;
    }

    public void setAlreadyMakeTaxAmount(BigDecimal alreadyMakeTaxAmount) {
        this.alreadyMakeTaxAmount = alreadyMakeTaxAmount;
    }

    public BigDecimal getAlreadyMakeAmountWithTax() {
        return alreadyMakeAmountWithTax;
    }

    public void setAlreadyMakeAmountWithTax(BigDecimal alreadyMakeAmountWithTax) {
        this.alreadyMakeAmountWithTax = alreadyMakeAmountWithTax;
    }

    public BigDecimal getAlreadyMakeDiscountWithoutTax() {
        return alreadyMakeDiscountWithoutTax;
    }

    public void setAlreadyMakeDiscountWithoutTax(BigDecimal alreadyMakeDiscountWithoutTax) {
        this.alreadyMakeDiscountWithoutTax = alreadyMakeDiscountWithoutTax;
    }

    public BigDecimal getAlreadyMakeDiscountTax() {
        return alreadyMakeDiscountTax;
    }

    public void setAlreadyMakeDiscountTax(BigDecimal alreadyMakeDiscountTax) {
        this.alreadyMakeDiscountTax = alreadyMakeDiscountTax;
    }

    public BigDecimal getAlreadyMakeDiscountWithTax() {
        return alreadyMakeDiscountWithTax;
    }

    public void setAlreadyMakeDiscountWithTax(BigDecimal alreadyMakeDiscountWithTax) {
        this.alreadyMakeDiscountWithTax = alreadyMakeDiscountWithTax;
    }

    @ApiModelProperty("扣除额")
    public BigDecimal getDeduction() {
        return deduction;
    }

    @JSONField(name = "deductions")
    public void setDeduction(BigDecimal deduction) {
        this.deduction = deduction;
    }

    @ApiModelProperty("剩余数量")
    public BigDecimal getLeftQuantity() {
        return leftQuantity;
    }

    public void setLeftQuantity(BigDecimal leftQuantity) {
        this.leftQuantity = leftQuantity;
    }

    @ApiModelProperty("剩余不含税金额")
    public BigDecimal getLeftAmountWithoutTax() {
        return leftAmountWithoutTax;
    }

    public void setLeftAmountWithoutTax(BigDecimal leftAmountWithoutTax) {
        this.leftAmountWithoutTax = leftAmountWithoutTax;
    }

    @ApiModelProperty("剩余税额")
    public BigDecimal getLeftTaxAmount() {
        return leftTaxAmount;
    }

    public void setLeftTaxAmount(BigDecimal leftTaxAmount) {
        this.leftTaxAmount = leftTaxAmount;
    }

    @ApiModelProperty("剩余含税金额")
    public BigDecimal getLeftAmountWithTax() {
        return leftAmountWithTax;
    }

    public void setLeftAmountWithTax(BigDecimal leftAmountWithTax) {
        this.leftAmountWithTax = leftAmountWithTax;
    }

    @ApiModelProperty("剩余折扣不含税金额")
    public BigDecimal getLeftDiscountWithoutTax() {
        return leftDiscountWithoutTax;
    }

    public void setLeftDiscountWithoutTax(BigDecimal leftDiscountWithoutTax) {
        this.leftDiscountWithoutTax = leftDiscountWithoutTax;
    }

    @ApiModelProperty("剩余折扣税额")
    public BigDecimal getLeftDiscountTax() {
        return leftDiscountTax;
    }

    public void setLeftDiscountTax(BigDecimal leftDiscountTax) {
        this.leftDiscountTax = leftDiscountTax;
    }

    @ApiModelProperty("备注")
    public BigDecimal getLeftDiscountWithTax() {
        return leftDiscountWithTax;
    }

    public void setLeftDiscountWithTax(BigDecimal leftDiscountWithTax) {
        this.leftDiscountWithTax = leftDiscountWithTax;
    }

    @ApiModelProperty("剩余扣除额")
    public BigDecimal getLeftTaxDeduction() {
        return leftTaxDeduction;
    }

    public void setLeftTaxDeduction(BigDecimal leftTaxDeduction) {
        this.leftTaxDeduction = leftTaxDeduction;
    }

    @ApiModelProperty("备注")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ApiModelProperty("拆分编码")
    public String getSplitCode() {
        return splitCode;
    }

    public void setSplitCode(String splitCode) {
        this.splitCode = splitCode;
    }

    @ApiModelProperty("分组编码")
    public String getItemTypeCode() {
        return itemTypeCode;
    }

    public void setItemTypeCode(String itemTypeCode) {
        this.itemTypeCode = itemTypeCode;
    }

    @ApiModelProperty("业务单明细号")
    public Long getSalesbillItemId() {
        return salesbillItemId;
    }

    public void setSalesbillItemId(Long salesbillItemId) {
        this.salesbillItemId = salesbillItemId;
    }

    @ApiModelProperty("业务单号")
    public Long getSalesbillId() {
        return salesbillId;
    }

    public void setSalesbillId(Long salesbillId) {
        this.salesbillId = salesbillId;
    }

    @JsonIgnore
    public BatchItem salesbillItemNo(String salesbillItemNo) {
        this.salesbillItemNo = salesbillItemNo;
        return this;
    }

    @ApiModelProperty("单据明细号")
    public String getSalesbillItemNo() {
        return salesbillItemNo;
    }

    public void setSalesbillItemNo(String salesbillItemNo) {
        this.salesbillItemNo = salesbillItemNo;
    }

    @JsonIgnore
    public BatchItem itemCode(String itemCode) {
        this.itemCode = itemCode;
        return this;
    }

    @ApiModelProperty("商品代码")
    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    @JsonIgnore
    public BatchItem itemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    @ApiModelProperty("商品名称")
    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    @JsonIgnore
    public BatchItem itemShortName(String itemShortName) {
        this.itemShortName = itemShortName;
        return this;
    }

    @ApiModelProperty("商品简称")
    public String getItemShortName() {
        return itemShortName;
    }

    public void setItemShortName(String itemShortName) {
        this.itemShortName = itemShortName;
    }

    @JsonIgnore
    public BatchItem itemSpec(String itemSpec) {
        this.itemSpec = itemSpec;
        return this;
    }

    @ApiModelProperty("规格型号")
    public String getItemSpec() {
        return itemSpec;
    }

    public void setItemSpec(String itemSpec) {
        this.itemSpec = itemSpec;
    }

    @JsonIgnore
    public BatchItem unitPriceWithTax(BigDecimal unitPriceWithTax) {
        this.unitPriceWithTax = unitPriceWithTax;
        return this;
    }

    @ApiModelProperty("含税单价")
    public BigDecimal getUnitPriceWithTax() {
        return unitPriceWithTax;
    }

    public void setUnitPriceWithTax(BigDecimal unitPriceWithTax) {
        this.unitPriceWithTax = unitPriceWithTax;
    }

    @JsonIgnore
    public BatchItem unitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @ApiModelProperty("不含税单价")
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    @JsonIgnore
    public BatchItem outterDiscountWithTax(BigDecimal outterDiscountWithTax) {
        this.outterDiscountWithTax = outterDiscountWithTax;
        return this;
    }

    @ApiModelProperty("价外折扣含税")
    public BigDecimal getOutterDiscountWithTax() {
        return outterDiscountWithTax;
    }

    public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
        this.outterDiscountWithTax = outterDiscountWithTax;
    }

    @JsonIgnore
    public BatchItem outterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
        this.outterDiscountWithoutTax = outterDiscountWithoutTax;
        return this;
    }

    @ApiModelProperty("价外折扣不含税")
    public BigDecimal getOutterDiscountWithoutTax() {
        return outterDiscountWithoutTax;
    }

    public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
        this.outterDiscountWithoutTax = outterDiscountWithoutTax;
    }

    @JsonIgnore
    public BatchItem outterDiscountTax(BigDecimal outterDiscountTax) {
        this.outterDiscountTax = outterDiscountTax;
        return this;
    }

    @ApiModelProperty("价外折扣税额")
    public BigDecimal getOutterDiscountTax() {
        return outterDiscountTax;
    }

    public void setOutterDiscountTax(BigDecimal outterDiscountTax) {
        this.outterDiscountTax = outterDiscountTax;
    }

    @JsonIgnore
    public BatchItem innerDiscountWithTax(BigDecimal innerDiscountWithTax) {
        this.innerDiscountWithTax = innerDiscountWithTax;
        return this;
    }

    @ApiModelProperty("价内折扣含税")
    public BigDecimal getInnerDiscountWithTax() {
        return innerDiscountWithTax;
    }

    public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
        this.innerDiscountWithTax = innerDiscountWithTax;
    }

    @JsonIgnore
    public BatchItem innerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
        this.innerDiscountWithoutTax = innerDiscountWithoutTax;
        return this;
    }

    @ApiModelProperty("价内折扣不含税")
    public BigDecimal getInnerDiscountWithoutTax() {
        return innerDiscountWithoutTax;
    }

    public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
        this.innerDiscountWithoutTax = innerDiscountWithoutTax;
    }

    @JsonIgnore
    public BatchItem innerDiscountTax(BigDecimal innerDiscountTax) {
        this.innerDiscountTax = innerDiscountTax;
        return this;
    }

    @ApiModelProperty("价内折扣含税")
    public BigDecimal getInnerDiscountTax() {
        return innerDiscountTax;
    }

    public void setInnerDiscountTax(BigDecimal innerDiscountTax) {
        this.innerDiscountTax = innerDiscountTax;
    }

    @JsonIgnore
    public BatchItem prepayAmountWithTax(BigDecimal prepayAmountWithTax) {
        this.prepayAmountWithTax = prepayAmountWithTax;
        return this;
    }

    public BigDecimal getInnerPrepayAmountWithTax() {
        return innerPrepayAmountWithTax;
    }

    public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
        this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
    }

    public BigDecimal getInnerPrepayAmountWithoutTax() {
        return innerPrepayAmountWithoutTax;
    }

    public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
        this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
    }

    public BigDecimal getInnerPrepayAmountTax() {
        return innerPrepayAmountTax;
    }

    public void setInnerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
        this.innerPrepayAmountTax = innerPrepayAmountTax;
    }

    public BigDecimal getOutterPrepayAmountWithTax() {
        return outterPrepayAmountWithTax;
    }

    public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
        this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
    }

    public BigDecimal getOutterPrepayAmountWithoutTax() {
        return outterPrepayAmountWithoutTax;
    }

    public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
        this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
    }

    public BigDecimal getOutterPrepayAmountTax() {
        return outterPrepayAmountTax;
    }

    public void setOutterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
        this.outterPrepayAmountTax = outterPrepayAmountTax;
    }

    @ApiModelProperty("预付卡含税金额")
    public BigDecimal getPrepayAmountWithTax() {
        return prepayAmountWithTax;
    }

    public void setPrepayAmountWithTax(BigDecimal prepayAmountWithTax) {
        this.prepayAmountWithTax = prepayAmountWithTax;
    }

    @JsonIgnore
    public BatchItem prepayAmountWithoutTax(BigDecimal prepayAmountWithoutTax) {
        this.prepayAmountWithoutTax = prepayAmountWithoutTax;
        return this;
    }

    @ApiModelProperty("预付卡不含税金额")
    public BigDecimal getPrepayAmountWithoutTax() {
        return prepayAmountWithoutTax;
    }

    public void setPrepayAmountWithoutTax(BigDecimal prepayAmountWithoutTax) {
        this.prepayAmountWithoutTax = prepayAmountWithoutTax;
    }

    @JsonIgnore
    public BatchItem prepayAmountTax(BigDecimal prepayAmountTax) {
        this.prepayAmountTax = prepayAmountTax;
        return this;
    }

    @ApiModelProperty("预付卡税额")
    public BigDecimal getPrepayAmountTax() {
        return prepayAmountTax;
    }

    public void setPrepayAmountTax(BigDecimal prepayAmountTax) {
        this.prepayAmountTax = prepayAmountTax;
    }

    @JsonIgnore
    public BatchItem quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty("数量")
    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    @JsonIgnore
    public BatchItem quantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
        return this;
    }

    @ApiModelProperty("数量单位")
    public String getQuantityUnit() {
        return quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    @JsonIgnore
    public BatchItem amountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
        return this;
    }

    @ApiModelProperty("含税金额")
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @JsonIgnore
    public BatchItem amountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    @ApiModelProperty("不含税金额")
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public BatchItem taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty("税额")
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    @JsonIgnore
    public BatchItem taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty("税率")
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    @JsonIgnore
    public BatchItem taxPre(String taxPre) {
        this.taxPre = taxPre;
        return this;
    }

    @ApiModelProperty("是否享受税收优惠政策0-不1-享受")
    public String getTaxPre() {
        return taxPre;
    }

    public void setTaxPre(String taxPre) {
        this.taxPre = taxPre;
    }

    @JsonIgnore
    public BatchItem taxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
        return this;
    }

    @ApiModelProperty("享受税收优惠政策内容")
    public String getTaxPreCon() {
        return taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    @JsonIgnore
    public BatchItem zeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
        return this;
    }

    @ApiModelProperty("零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率")
    public String getZeroTax() {
        return zeroTax;
    }

    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
    }

    @JsonIgnore
    public BatchItem goodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
        return this;
    }

    @ApiModelProperty("税收分类编码")
    public String getGoodsTaxNo() {
        return goodsTaxNo;
    }

    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
    }

    @JsonIgnore
    public BatchItem taxConvertCode(String taxConvertCode) {
        this.taxConvertCode = taxConvertCode;
        return this;
    }

    @ApiModelProperty("税编转换代码")
    public String getTaxConvertCode() {
        return taxConvertCode;
    }

    public void setTaxConvertCode(String taxConvertCode) {
        this.taxConvertCode = taxConvertCode;
    }

    @JsonIgnore
    public BatchItem largeCategoryName(String largeCategoryName) {
        this.largeCategoryName = largeCategoryName;
        return this;
    }

    @ApiModelProperty("项目大类")
    public String getLargeCategoryName() {
        return largeCategoryName;
    }

    public void setLargeCategoryName(String largeCategoryName) {
        this.largeCategoryName = largeCategoryName;
    }

    @JsonIgnore
    public BatchItem medianCategoryName(String medianCategoryName) {
        this.medianCategoryName = medianCategoryName;
        return this;
    }

    @ApiModelProperty("项目中类")
    public String getMedianCategoryName() {
        return medianCategoryName;
    }

    public void setMedianCategoryName(String medianCategoryName) {
        this.medianCategoryName = medianCategoryName;
    }

    @JsonIgnore
    public BatchItem smallCategoryName(String smallCategoryName) {
        this.smallCategoryName = smallCategoryName;
        return this;
    }

    @ApiModelProperty("项目小类")
    public String getSmallCategoryName() {
        return smallCategoryName;
    }

    public void setSmallCategoryName(String smallCategoryName) {
        this.smallCategoryName = smallCategoryName;
    }

    @JsonIgnore
    public BatchItem ext1(String ext1) {
        this.ext1 = ext1;
        return this;
    }

    @ApiModelProperty("扩展字段1")
    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    @JsonIgnore
    public BatchItem ext2(String ext2) {
        this.ext2 = ext2;
        return this;
    }

    @ApiModelProperty("")
    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    @JsonIgnore
    public BatchItem ext3(String ext3) {
        this.ext3 = ext3;
        return this;
    }

    @ApiModelProperty("扩展字段3")
    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    @JsonIgnore
    public BatchItem ext4(String ext4) {
        this.ext4 = ext4;
        return this;
    }

    @ApiModelProperty("扩展字段4")
    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    @JsonIgnore
    public BatchItem ext5(String ext5) {
        this.ext5 = ext5;
        return this;
    }

    @ApiModelProperty("扩展字段5")
    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    @JsonIgnore
    public BatchItem ext6(String ext6) {
        this.ext6 = ext6;
        return this;
    }

    @ApiModelProperty("扩展字段6")
    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    @JsonIgnore
    public BatchItem ext7(String ext7) {
        this.ext7 = ext7;
        return this;
    }

    @ApiModelProperty("扩展字段7")
    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    @JsonIgnore
    public BatchItem ext8(String ext8) {
        this.ext8 = ext8;
        return this;
    }

    @ApiModelProperty("扩展字段8")
    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    @JsonIgnore
    public BatchItem ext9(String ext9) {
        this.ext9 = ext9;
        return this;
    }

    @ApiModelProperty("扩展字段9")
    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    @JsonIgnore
    public BatchItem ext10(String ext10) {
        this.ext10 = ext10;
        return this;
    }

    @ApiModelProperty("扩展字段10")
    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    @JsonIgnore
    public BatchItem ext11(String ext11) {
        this.ext11 = ext11;
        return this;
    }

    @ApiModelProperty("扩展字段11")
    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    @JsonIgnore
    public BatchItem ext12(String ext12) {
        this.ext12 = ext12;
        return this;
    }

    @ApiModelProperty("扩展字段12")
    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    @JsonIgnore
    public BatchItem ext13(String ext13) {
        this.ext13 = ext13;
        return this;
    }

    @ApiModelProperty("扩展字段13")
    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    @JsonIgnore
    public BatchItem ext14(String ext14) {
        this.ext14 = ext14;
        return this;
    }

    @ApiModelProperty("扩展字段14")
    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    @JsonIgnore
    public BatchItem ext15(String ext15) {
        this.ext15 = ext15;
        return this;
    }

    @ApiModelProperty("扩展字段15")
    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    @JsonIgnore
    public BatchItem ext16(String ext16) {
        this.ext16 = ext16;
        return this;
    }

    @ApiModelProperty("扩展字段16")
    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    @JsonIgnore
    public BatchItem ext17(String ext17) {
        this.ext17 = ext17;
        return this;
    }

    @ApiModelProperty("扩展字段17")
    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    @JsonIgnore
    public BatchItem ext18(String ext18) {
        this.ext18 = ext18;
        return this;
    }

    @ApiModelProperty("扩展字段18")
    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    @JsonIgnore
    public BatchItem ext19(String ext19) {
        this.ext19 = ext19;
        return this;
    }

    @ApiModelProperty("扩展字段19")
    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    @JsonIgnore
    public BatchItem ext20(String ext20) {
        this.ext20 = ext20;
        return this;
    }

    @ApiModelProperty("扩展字段20")
    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if ((o == null) || (getClass() != o.getClass())) {
            return false;
        }
        BatchItem billUploadItem = (BatchItem) o;
        return (Objects.equals(salesbillItemNo, salesbillItemNo)) && (Objects.equals(itemCode, itemCode))
                && (Objects.equals(itemName, itemName)) && (Objects.equals(itemShortName, itemShortName))
                && (Objects.equals(itemSpec, itemSpec)) && (Objects.equals(unitPriceWithTax, unitPriceWithTax))
                && (Objects.equals(unitPrice, unitPrice))
                && (Objects.equals(outterDiscountWithTax, outterDiscountWithTax))
                && (Objects.equals(outterDiscountWithoutTax, outterDiscountWithoutTax))
                && (Objects.equals(outterDiscountTax, outterDiscountTax))
                && (Objects.equals(innerDiscountWithTax, innerDiscountWithTax))
                && (Objects.equals(innerDiscountWithoutTax, innerDiscountWithoutTax))
                && (Objects.equals(innerDiscountTax, innerDiscountTax))
                && (Objects.equals(prepayAmountWithTax, prepayAmountWithTax))
                && (Objects.equals(prepayAmountWithoutTax, prepayAmountWithoutTax))
                && (Objects.equals(prepayAmountTax, prepayAmountTax)) && (Objects.equals(quantity, quantity))
                && (Objects.equals(quantityUnit, quantityUnit)) && (Objects.equals(amountWithTax, amountWithTax))
                && (Objects.equals(amountWithoutTax, amountWithoutTax)) && (Objects.equals(taxAmount, taxAmount))
                && (Objects.equals(taxRate, taxRate)) && (Objects.equals(taxPre, taxPre))
                && (Objects.equals(taxPreCon, taxPreCon)) && (Objects.equals(zeroTax, zeroTax))
                && (Objects.equals(goodsTaxNo, goodsTaxNo)) && (Objects.equals(taxConvertCode, taxConvertCode))
                && (Objects.equals(largeCategoryName, largeCategoryName))
                && (Objects.equals(medianCategoryName, medianCategoryName))
                && (Objects.equals(smallCategoryName, smallCategoryName)) && (Objects.equals(ext1, ext1))
                && (Objects.equals(ext2, ext2)) && (Objects.equals(ext3, ext3)) && (Objects.equals(ext4, ext4))
                && (Objects.equals(ext5, ext5)) && (Objects.equals(ext6, ext6)) && (Objects.equals(ext7, ext7))
                && (Objects.equals(ext8, ext8)) && (Objects.equals(ext9, ext9)) && (Objects.equals(ext10, ext10))
                && (Objects.equals(ext11, ext11)) && (Objects.equals(ext12, ext12)) && (Objects.equals(ext13, ext13))
                && (Objects.equals(ext14, ext14)) && (Objects.equals(ext15, ext15)) && (Objects.equals(ext16, ext16))
                && (Objects.equals(ext17, ext17)) && (Objects.equals(ext18, ext18)) && (Objects.equals(ext19, ext19))
                && (Objects.equals(ext20, ext20));
    }

    public int hashCode() {
        return Objects.hash(new Object[] { salesbillItemNo, itemCode, itemName, itemShortName, itemSpec, unitPriceWithTax,
                unitPrice, outterDiscountWithTax, outterDiscountWithoutTax, outterDiscountTax, innerDiscountWithTax,
                innerDiscountWithoutTax, innerDiscountTax, prepayAmountWithTax, prepayAmountWithoutTax, prepayAmountTax,
                quantity, quantityUnit, amountWithTax, amountWithoutTax, taxAmount, taxRate, taxPre, taxPreCon, zeroTax,
                goodsTaxNo, taxConvertCode, largeCategoryName, medianCategoryName, smallCategoryName, ext1, ext2, ext3,
                ext4, ext5, ext6, ext7, ext8, ext9, ext10, ext11, ext12, ext13, ext14, ext15, ext16, ext17, ext18,
                ext19, ext20});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchItem {\n");

        sb.append("    salesbillItemNo: ").append(toIndentedString(salesbillItemNo)).append("\n");
        sb.append("    itemCode: ").append(toIndentedString(itemCode)).append("\n");
        sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
        sb.append("    itemShortName: ").append(toIndentedString(itemShortName)).append("\n");
        sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
        sb.append("    unitPriceWithTax: ").append(toIndentedString(unitPriceWithTax)).append("\n");
        sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
        sb.append("    outterDiscountWithTax: ").append(toIndentedString(outterDiscountWithTax)).append("\n");
        sb.append("    outterDiscountWithoutTax: ").append(toIndentedString(outterDiscountWithoutTax)).append("\n");
        sb.append("    outterDiscountTax: ").append(toIndentedString(outterDiscountTax)).append("\n");
        sb.append("    innerDiscountWithTax: ").append(toIndentedString(innerDiscountWithTax)).append("\n");
        sb.append("    innerDiscountWithoutTax: ").append(toIndentedString(innerDiscountWithoutTax)).append("\n");
        sb.append("    innerDiscountTax: ").append(toIndentedString(innerDiscountTax)).append("\n");
        sb.append("    prepayAmountWithTax: ").append(toIndentedString(prepayAmountWithTax)).append("\n");
        sb.append("    prepayAmountWithoutTax: ").append(toIndentedString(prepayAmountWithoutTax)).append("\n");
        sb.append("    prepayAmountTax: ").append(toIndentedString(prepayAmountTax)).append("\n");
        sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
        sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
        sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
        sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
        sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
        sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
        sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
        sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
        sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
        sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
        sb.append("    taxConvertCode: ").append(toIndentedString(taxConvertCode)).append("\n");
        sb.append("    largeCategoryName: ").append(toIndentedString(largeCategoryName)).append("\n");
        sb.append("    medianCategoryName: ").append(toIndentedString(medianCategoryName)).append("\n");
        sb.append("    smallCategoryName: ").append(toIndentedString(smallCategoryName)).append("\n");
        sb.append("    ext1: ").append(toIndentedString(ext1)).append("\n");
        sb.append("    ext2: ").append(toIndentedString(ext2)).append("\n");
        sb.append("    ext3: ").append(toIndentedString(ext3)).append("\n");
        sb.append("    ext4: ").append(toIndentedString(ext4)).append("\n");
        sb.append("    ext5: ").append(toIndentedString(ext5)).append("\n");
        sb.append("    ext6: ").append(toIndentedString(ext6)).append("\n");
        sb.append("    ext7: ").append(toIndentedString(ext7)).append("\n");
        sb.append("    ext8: ").append(toIndentedString(ext8)).append("\n");
        sb.append("    ext9: ").append(toIndentedString(ext9)).append("\n");
        sb.append("    ext10: ").append(toIndentedString(ext10)).append("\n");
        sb.append("    ext11: ").append(toIndentedString(ext11)).append("\n");
        sb.append("    ext12: ").append(toIndentedString(ext12)).append("\n");
        sb.append("    ext13: ").append(toIndentedString(ext13)).append("\n");
        sb.append("    ext14: ").append(toIndentedString(ext14)).append("\n");
        sb.append("    ext15: ").append(toIndentedString(ext15)).append("\n");
        sb.append("    ext16: ").append(toIndentedString(ext16)).append("\n");
        sb.append("    ext17: ").append(toIndentedString(ext17)).append("\n");
        sb.append("    ext18: ").append(toIndentedString(ext18)).append("\n");
        sb.append("    ext19: ").append(toIndentedString(ext19)).append("\n");
        sb.append("    ext20: ").append(toIndentedString(ext20)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
