package com.xforceplus.seller.invoice.client.model;


import io.swagger.annotations.ApiModelProperty;


import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;


public class InvSellerInvoiceVoidBillRequest {


    /**
     * 发票唯一标识
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : seller_invoice_id
     */
    @ApiModelProperty("发票唯一标识")
    private Long sellerInvoiceId;

    /**
     * 物流单号
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : logistics_bill_no
     */
    @ApiModelProperty("物流单号")
    private String logisticsBillNo;

    /**
     * 邮寄单号
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : send_no
     */
    @ApiModelProperty("邮寄单号")
    private String sendNo;

    /**
     * 邮寄地址
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : send_address
     */
    @ApiModelProperty("邮寄地址")
    private String sendAddress;

    /**
     * 邮寄城市
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : send_city
     */
    @ApiModelProperty("邮寄城市")
    private String sendCity;

    /**
     * 邮寄日期
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : send_time
     */
    @ApiModelProperty("邮寄日期")
    private String sendTime;

    /**
     * 邮编
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : post_code
     */
    @ApiModelProperty("邮编")
    private String postCode;

    /**
     * 收件人
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : receiver_name
     */
    @ApiModelProperty("收件人")
    private String receiverName;

    /**
     * 收件人单位
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : receiver_unit
     */
    @ApiModelProperty("收件人单位")
    private String receiverUnit;

    /**
     * 收件人电话
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : receiver_tel
     */
    @ApiModelProperty("收件人电话")
    private String receiverTel;

    /**
     * 代收人
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : replace_user
     */
    @ApiModelProperty("代收人")
    private String replaceUser;

    /**
     * 代收人电话
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : replace_user_tel
     */
    @ApiModelProperty("代收人电话")
    private String replaceUserTel;

    /**
     * 收件人地址
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : receiver_address
     */
    @ApiModelProperty("收件人地址")
    private String receiverAddress;

    /**
     * 作废申请类型(遗失,退回)
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : void_apply_type
     */
    @ApiModelProperty("作废申请类型(遗失,退回)")
    private Integer voidApplyType;

    /**
     * 退回原因
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : back_reason
     */
    @ApiModelProperty("退回原因")
    private Integer backReason;

    /**
     * 创建部门
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : office_name
     */
    @ApiModelProperty("创建部门")
    private String officeName;

    /**
     * 寄送方式
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : send_type
     */
    @ApiModelProperty("寄送方式")
    private Integer sendType;

    /**
     * 作废方式
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : void_type
     */
    @ApiModelProperty("作废方式")
    private Integer voidType;

    /**
     * 录入人
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : create_user
     */
    @ApiModelProperty("录入人")
    private Long createUser;

    /**
     * 申请人
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : apply_user
     */
    @ApiModelProperty("申请人")
    private String applyUser;

    /**
     * 申请原因
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : apply_reason
     */
    @ApiModelProperty("申请原因")
    private String applyReason;

    /**
     * 申请备注
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : apply_remark
     */
    @ApiModelProperty("申请备注")
    private String applyRemark;

    /**
     * 发票代码
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : invoice_code
     */
    @ApiModelProperty("发票代码")
    private String invoiceCode;

    /**
     * 发票号码
     * 表 : inv_seller_invoice_void_bill
     * 对应字段 : invoice_no
     */
    @ApiModelProperty("发票号码")
    private String invoiceNo;

    /**
     * 作废申请单附件
     */
    @ApiModelProperty("作废申请单附件")
    private List<ApplyVoidBillAttachmentVo> voidBillAttachmentFiles;


    public Long getSellerInvoiceId() {
        return sellerInvoiceId;
    }

    public void setSellerInvoiceId(Long sellerInvoiceId) {
        this.sellerInvoiceId = sellerInvoiceId;
    }

    public String getLogisticsBillNo() {
        return logisticsBillNo;
    }

    public void setLogisticsBillNo(String logisticsBillNo) {
        this.logisticsBillNo = logisticsBillNo;
    }

    public String getSendNo() {
        return sendNo;
    }

    public void setSendNo(String sendNo) {
        this.sendNo = sendNo;
    }

    public String getSendAddress() {
        return sendAddress;
    }

    public void setSendAddress(String sendAddress) {
        this.sendAddress = sendAddress;
    }

    public String getSendCity() {
        return sendCity;
    }

    public void setSendCity(String sendCity) {
        this.sendCity = sendCity;
    }

    public String getSendTime() {
        return sendTime;
    }

    public void setSendTime(String sendTime) {
        this.sendTime = sendTime;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverUnit() {
        return receiverUnit;
    }

    public void setReceiverUnit(String receiverUnit) {
        this.receiverUnit = receiverUnit;
    }

    public String getReceiverTel() {
        return receiverTel;
    }

    public void setReceiverTel(String receiverTel) {
        this.receiverTel = receiverTel;
    }

    public String getReplaceUser() {
        return replaceUser;
    }

    public void setReplaceUser(String replaceUser) {
        this.replaceUser = replaceUser;
    }

    public String getReplaceUserTel() {
        return replaceUserTel;
    }

    public void setReplaceUserTel(String replaceUserTel) {
        this.replaceUserTel = replaceUserTel;
    }

    public String getReceiverAddress() {
        return receiverAddress;
    }

    public void setReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    public Integer getVoidApplyType() {
        return voidApplyType;
    }

    public void setVoidApplyType(Integer voidApplyType) {
        this.voidApplyType = voidApplyType;
    }

    public Integer getBackReason() {
        return backReason;
    }

    public void setBackReason(Integer backReason) {
        this.backReason = backReason;
    }

    public String getOfficeName() {
        return officeName;
    }

    public void setOfficeName(String officeName) {
        this.officeName = officeName;
    }

    public Integer getSendType() {
        return sendType;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public Integer getVoidType() {
        return voidType;
    }

    public void setVoidType(Integer voidType) {
        this.voidType = voidType;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public String getApplyUser() {
        return applyUser;
    }

    public void setApplyUser(String applyUser) {
        this.applyUser = applyUser;
    }

    public String getApplyReason() {
        return applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }

    public String getApplyRemark() {
        return applyRemark;
    }

    public void setApplyRemark(String applyRemark) {
        this.applyRemark = applyRemark;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public List<ApplyVoidBillAttachmentVo> getVoidBillAttachmentFiles() {
        return voidBillAttachmentFiles;
    }

    public void setVoidBillAttachmentFiles(List<ApplyVoidBillAttachmentVo> voidBillAttachmentFiles) {
        this.voidBillAttachmentFiles = voidBillAttachmentFiles;
    }
}
