package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票信息分页返回结果
 */
@ApiModel(description = "发票信息分页返回结果")

@JsonInclude(NON_NULL)
public class InvoicePageQueryResult {
  @JsonProperty("normal")
  private Long normal = null;

  @JsonProperty("panding")
  private Long panding = null;

  @JsonProperty("abandoned")
  private Long abandoned = null;

  @JsonProperty("auditRejected")
  private Long auditRejected = null;

  @JsonProperty("auditPass")
  private Long auditPass = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("list")
  private List<SellerInvoiceInfo> list = new ArrayList<SellerInvoiceInfo>();

  @JsonIgnore
  public InvoicePageQueryResult normal(Long normal) {
    this.normal = normal;
    return this;
  }

   /**
   * 正常条数
   * @return normal
  **/
  @ApiModelProperty(value = "正常条数")
  public Long getNormal() {
    return normal;
  }

  public void setNormal(Long normal) {
    this.normal = normal;
  }

  @JsonIgnore
  public InvoicePageQueryResult panding(Long panding) {
    this.panding = panding;
    return this;
  }

   /**
   * 待处理条数
   * @return panding
  **/
  @ApiModelProperty(value = "待处理条数")
  public Long getPanding() {
    return panding;
  }

  public void setPanding(Long panding) {
    this.panding = panding;
  }

  @JsonIgnore
  public InvoicePageQueryResult abandoned(Long abandoned) {
    this.abandoned = abandoned;
    return this;
  }

   /**
   * 已作废条数
   * @return abandoned
  **/
  @ApiModelProperty(value = "已作废条数")
  public Long getAbandoned() {
    return abandoned;
  }

  public void setAbandoned(Long abandoned) {
    this.abandoned = abandoned;
  }

  @JsonIgnore
  public InvoicePageQueryResult total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 总条数
   * @return total
  **/
  @ApiModelProperty(value = "总条数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public InvoicePageQueryResult list(List<SellerInvoiceInfo> list) {
    this.list = list;
    return this;
  }

  public InvoicePageQueryResult addListItem(SellerInvoiceInfo listItem) {
    this.list.add(listItem);
    return this;
  }

  public Long getAuditRejected() {
    return auditRejected;
  }

  public void setAuditRejected(Long auditRejected) {
    this.auditRejected = auditRejected;
  }

  public Long getAuditPass() {
    return auditPass;
  }

  public void setAuditPass(Long auditPass) {
    this.auditPass = auditPass;
  }

  /**
   * 发票信息查询列表
   * @return list
  **/
  @ApiModelProperty(value = "发票信息查询列表")
  public List<SellerInvoiceInfo> getList() {
    return list;
  }

  public void setList(List<SellerInvoiceInfo> list) {
    this.list = list;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicePageQueryResult invoicePageQueryResult = (InvoicePageQueryResult) o;
    return Objects.equals(this.normal, invoicePageQueryResult.normal) &&
        Objects.equals(this.panding, invoicePageQueryResult.panding) &&
        Objects.equals(this.abandoned, invoicePageQueryResult.abandoned) &&
        Objects.equals(this.total, invoicePageQueryResult.total) &&
        Objects.equals(this.list, invoicePageQueryResult.list);
  }

  @Override
  public int hashCode() {
    return Objects.hash(normal, panding, abandoned, total, list);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicePageQueryResult {\n");

    sb.append("    normal: ").append(toIndentedString(normal)).append("\n");
    sb.append("    panding: ").append(toIndentedString(panding)).append("\n");
    sb.append("    abandoned: ").append(toIndentedString(abandoned)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    list: ").append(toIndentedString(list)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
